% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssh.data.shp.r
\name{ssh.data.shp}
\alias{ssh.data.shp}
\title{Prepare shapefile data for Geodetector}
\usage{
ssh.data.shp(object,
       ssh.lyr,
       ssh.id,
       ssh.name=NULL)
}
\arguments{
\item{object}{A point \code{sf} object to be joint. Its geometry should be consistent with the sampling layer, but it may have additional attributes from the SSH layer(s).}

\item{ssh.lyr}{A polygon \code{sf} object used as the candidate SSH layer. Its stratum ID will be linked to \code{object}.}

\item{ssh.id}{Text for the field name of stratum ID in the SSH layer.}

\item{ssh.name}{Text for the new field name assigned to the stratum ID in the output object. If \code{NULL}, the attribute name will be the same as that in the old SSH layer.}
}
\value{
An \code{sf} object with the sampling units and the Strata they fall into.
}
\description{
Join a candidate SSH layer to an existing layer for the geographical detector model.
}
\examples{
library(sf)
library(tools)
data(hs.data)
hs.ssh2.name <- system.file("extdata", "hs.ssh2.shapefile.shp",
                            package="sandwichr")
hs.ssh2 <- read_sf(dsn=dirname(hs.ssh2.name),
                  layer=file_path_sans_ext(basename(hs.ssh2.name)))
hs.join <- ssh.data.shp(object=hs.data[[1]], ssh.lyr=hs.data[[2]], ssh.id="STR_1")
hs.join <- ssh.data.shp(object=hs.join, ssh.lyr=hs.ssh2, ssh.id="STR_2")

}
