% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.sandwich.r
\name{summary}
\alias{summary}
\alias{summary.sandwich.model}
\alias{summary.sandwich.ci}
\title{Summarize interpolation results}
\usage{
\method{summary}{sandwich.model}(object, ...)

\method{summary}{sandwich.ci}(object, ...)
}
\arguments{
\item{object}{A \code{sandwich.ci} object generated by \code{\link{sandwich.ci}}, or a \code{sandwich.model} object generated by \code{\link{sandwich.model}}.}

\item{...}{Ignored.}
}
\value{
Summarized statistics for the estimated mean, standard error, and confidence interval.
}
\description{
Summarize the estimated mean, standard error, and confidence interval.
}
\examples{
data(hs.data)
hs.sw <- sandwich.model(object=hs.data, sampling.attr="Population", type="shp")
summary(object=hs.sw)

hs.sw.ci <- sandwich.ci(object=hs.sw, level=.95)
summary(object=hs.sw.ci)

}
\seealso{
\code{\link{sandwich.model}}, \code{\link{sandwich.ci}}
}
