% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.sandwich.r
\name{autoplot}
\alias{autoplot}
\alias{autoplot.sandwich.model}
\title{Plot interpolation results}
\usage{
\method{autoplot}{sandwich.model}(
  object,
  titles = c("Mean", "Standard Error"),
  labels = c("", ""),
  border_color = "darkgray",
  poly_fill_mean = c("white", "red"),
  poly_fill_se = c("white", "blue"),
  ...
)
}
\arguments{
\item{object}{A \code{sandwich.model} object generated by \code{\link{sandwich.model}}.}

\item{titles}{A list of texts for the titles.}

\item{labels}{A list of texts for the legend labels.}

\item{border_color}{Color for outlines of the polygons.}

\item{poly_fill_mean}{A list of colors for low and high ends of the gradient in the mapping of means.}

\item{poly_fill_se}{A list of colors for low and high ends of the gradient in the mapping of standard errors.}

\item{...}{Ignored.}
}
\value{
A list of \code{ggplot} objects.
}
\description{
Plot the estimated mean and standard error for each reporting unit.
}
\examples{
library(ggplot2)
data(sim.data)
sim.sw <- sandwich.model(object=sim.data, sampling.attr="Value", type="shp")
ggplot2::autoplot(object=sim.sw)


}
\references{
Wang, J. F., Haining, R., Liu, T. J., Li, L. F., & Jiang, C. S. (2013). Sandwich estimation for multi-unit reporting on a stratified heterogeneous surface. \emph{Environment and Planning A}, 45(10), 2515-2534.
}
\seealso{
\code{\link{sandwich.model}}
}
