% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sandwich.cv.r
\name{sandwich.cv}
\alias{sandwich.cv}
\title{Perform \emph{k}-fold cross validation}
\usage{
sandwich.cv(object,
       sampling.attr,
       k=10,
       type="shp",
       ssh.id.col=NULL,
       reporting.id.col=NULL,
       ssh.weights=NULL)
}
\arguments{
\item{object}{When \code{type="shp"}, \code{object} is a list of three \code{sf} objects generated by \code{\link{load.data.shp}}, including a point \code{sf} object used as the sampling layer, a polygon \code{sf} object used as the SSH layer, and a polygon \code{sf} object used as the SSH layer. When \code{type="txt"}, \code{object} is a list of two data frames generated by \code{\link{load.data.txt}}, including a file linking sampling and SSH layers and a file linking reporting and SSH layers.}

\item{sampling.attr}{Text for the name of the attribute to be interpolated  in the sampling layer.}

\item{k}{Number of folds (\code{k} > 1). By default, \code{k} = 10.}

\item{type}{Text for the type of input data. \code{type="shp"} denotes shapefiles, and \code{type="txt"} denotes text files. By default, \code{type="shp"}.}

\item{ssh.id.col}{Text for the column that specifies which stratum each sampling unit falls into (see \code{\link{load.data.txt}}). Set to \code{NULL} when \code{type="shp"}.}

\item{reporting.id.col}{Text for the column that specifies which reporting unit each sampling unit falls into (see \code{\link{load.data.txt}}). Set to \code{NULL} when \code{type="shp"}.}

\item{ssh.weights}{A \code{list} that specifies the strata in the SSH layer and their corresponding columns of weights in \code{reporting_ssh.file} (see \code{\link{load.data.txt}}).}
}
\value{
A value of the \emph{k}-fold cross validation estimate.
}
\description{
Perform \emph{k}-fold cross validation to evaluate the overall model accuracy and output the average root mean square error (RMSE).
}
\seealso{
\code{\link{load.data.shp}}, \code{\link{load.data.txt}}
}
