% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_search.R
\name{plot_nbTP_histogram}
\alias{plot_nbTP_histogram}
\title{Plot an histogram of the number of time-trajectories with a given number of time-points}
\usage{
plot_nbTP_histogram(eigen, dfCutOff = NA)
}
\arguments{
\item{eigen}{A list of eigenSpline parameters as generated by \code{\link{get_eigen_spline}}, containing \code{eigen$matrix}, \code{eigen$variance}, \code{eigen$model} and \code{eigen$countTP}.}

\item{dfCutOff}{(int) A number (a selected \emph{df}) to highlight the portion of trajectories that would be rejected form the dataset (numberTP < \emph{df}). Default is NA, with no cut-off plotted.}
}
\value{
A ggplot2 plotObject.
}
\description{
Histogram of the number of time-trajectories with a minimum number of time-points. When the number of time-points is inferior to the \emph{df} selected, a spline cannot be fitted. The histogram highlights the number and percentage of time-trajectories that will be rejected for a given \emph{df}.
}
\examples{
## 8 subjects, 4 time-points, 3 variables, some missing values
inputData  <- acuteInflammation$data[0:32,1:3]
inputData  <- inputData[-1,]
inputData  <- inputData[-8,]
inputData  <- inputData[-30,]
inputData  <- inputData[-29,]
ind        <- acuteInflammation$meta$ind[0:32]
ind        <- ind[-1]
ind        <- ind[-8]
ind        <- ind[-30]
ind        <- ind[-29]
time       <- acuteInflammation$meta$time[0:32]
time       <- time[-1]
time       <- time[-8]
time       <- time[-30]
time       <- time[-29]
eigen      <- get_eigen_spline(inputData, ind, time, nPC=NA, scaling="scaling_UV",
                               method="nipals", verbose=TRUE, centering=TRUE, ncores=0)
plot_nbTP_histogram(eigen, dfCutOff=3)

}
\seealso{
Graphical implementation with \code{\link{santaR_start_GUI}}

Other DFsearch: 
\code{\link{get_eigen_DFoverlay_list}()},
\code{\link{get_eigen_DF}()},
\code{\link{get_eigen_spline}()},
\code{\link{get_param_evolution}()},
\code{\link{plot_param_evolution}()}
}
\concept{DFsearch}
