
## Do not edit this file manually.
## It has been automatically generated from *.org sources.

armaccf_xe <- function(model, lag.max = 1){
    phi <- model$ar
    theta <- model$ma
    sigmasq <- model$sigmasq

    p <- length(phi)
    q <- length(theta)

    lag.max <- max(lag.max, max(p,q))

    Rxe <- numeric(lag.max + 1)
    Rxe[1] <- sigmasq
    for(lag in seq(length = q)){ # TODO: this seems to assume p>q  !!!
        ind <- lag + 1
        minkp <- min(lag,p)
        Rxe[ind] <- sum(phi[1:minkp] * Rxe[lag:(lag - minkp + 1)]) + theta[lag] * sigmasq
    }

    if(p > q){  ## q, ..., min(p, lag.max) but this is always p, see above
        for(lag in seq((q + 1):p)){
            ind <- lag + 1
            Rxe[ind] <- sum(phi[1:lag] * Rxe[lag:1])
        }
    }

    if(lag.max > p){
        for(lag in seq((p + 1):lag.max)){
            ind <- lag + 1
            Rxe[ind] <- sum(phi[1:p] * Rxe[lag:(lag - p + 1)])
        }
    }

    term0 <- Rxe[1] + sum(theta * Rxe[ seq(from = 2, length=q)] )

    list(Rxe = Rxe, term0 = term0)
}

armaacf <- function(model, lag.max){  ## TODO: unfinished; Notice browser() below !!!
    xe <- armaccf_xe(model, lag.max)
    Rxe <- xe$Rxe
    term0 <- xe$term0

    phi <- model$ar
    p <- length(phi)

    acrf <- ARMAacf(model$ar, model$ma, lag.max)
    R0 <-  term0  / (1 - sum( phi * acrf[seq(from = 2, length = p)]))

    res2 <- tacvfARMA(model$ar, - model$ma, lag.max, model$sigmasq)

    res <- acrf * R0

    browser()

    res
}
