% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_qmd_chapters.R
\name{gen_qmd_chapters}
\alias{gen_qmd_chapters}
\title{Generate A Quarto Survey Report}
\usage{
gen_qmd_chapters(
  chapter_overview,
  data,
  mesos_group = NULL,
  ...,
  call = rlang::caller_env()
)
}
\arguments{
\item{chapter_overview}{\emph{What goes in each chapter}

\verb{obj:<data.frame>|obj:<tbl_df>} // Required

Data frame (or tibble, possibly grouped). One row per chapter. Should
contain the columns 'chapter' and 'dep', Optionally 'indep' (independent
variables) and other informative columns as needed.}

\item{data}{\emph{Survey data}

\verb{obj:<data.frame>|obj:<tbl_df>} // Required

A data frame (or a srvyr-object) with the columns specified in the
chapter_overview 'dep_cat', etc columns.}

\item{mesos_group}{\emph{Specific group to compare with}

\verb{scalar<character>} // \emph{Default:} \code{NULL} (\code{optional})

Both the absolute and relative folderpaths are required, as strings.}

\item{...}{\emph{Dynamic dots}

<\href{https://rlang.r-lib.org/reference/dyn-dots.html}{\code{dynamic-dots}}>

Arguments forwarded to the corresponding functions that create the elements.}

\item{call}{\emph{Internal call}

\verb{obj:<call>} // \emph{Default:} \code{rlang::caller_env()} (\code{optional})

Both the absolute and relative folderpaths are required, as strings.}
}
\value{
A Quarto survey report generated in the specified working directory.
}
\description{
This function generates a Quarto survey report.
}
\details{
A report consists of multiple chapters and an index file that merges them together.
A chapter can contain any user-defined set of dependent, independent or bivariate variable sets.
A chapter consists of multiple sections.
A section is defined as a group in the chapter_overview (ignoring the chapter grouping level) containing variables of the same type, meaning at a minimum that the variables in the section sharing the same response options, the same main question, and being of the same data type.
}
\keyword{internal}
