% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmZeroThicknessLayers.R
\name{rmZeroThicknessLayers}
\alias{rmZeroThicknessLayers}
\title{Remove layers with a thickness of 'zero cm'}
\usage{
rmZeroThicknessLayers(x, rm.zero.thickness = TRUE)
}
\arguments{
\item{x}{A \code{snowprofile} or \code{snowprofileLayers} object}

\item{rm.zero.thickness}{Want to remove zero-thickness layers from profile? boolean, default TRUE. If FALSE, those
zero-thickness layers will be reset to the lower adjacent (non-zero-thickness) layer; thus, the number of layers
won't be changed.}
}
\value{
A modified copy of the input object. For snowprofile objects, the field \verb{$changes} will be initialized or
extended.
}
\description{
Find layers in a snow profile that are zero cm thick (i.e. height vector stays constant for some layers, even
though grain types or hardness may change). Then, either remove those layers, or reset them with the layer
characteristics of the lower adjacent (non-zero-thickness) layer. In the latter case (i.e., reset), the number of
layers won't change, but those non-zero thickness layers will be made ineffective.
This procedure is particularly necessary for warping snow profiles (cf., \link{dtwSP}, \link{warpSP}).
}
\author{
fherla
}
