% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowprofileTests.R
\name{snowprofileTests}
\alias{snowprofileTests}
\title{Constructor for a snowprofileTests object}
\usage{
snowprofileTests(
  testsFrame = data.frame(type = as.character(NA), result = as.character(NA), score =
    as.double(NA), fract_char = as.character(NA), depth = as.double(NA), comment =
    as.character(NA)),
  dropNAs = TRUE
)
}
\arguments{
\item{testsFrame}{a data.frame listing snowpack stability tests. Rows correspond to individual tests and columns describe at least the
fields \code{c("type", "result", "fract_char", "score", "depth")}.
\itemize{
\item Test \strong{type} and \strong{result} yield the standard 'data code' for reporting snowpack tests according to the OGRS (see Details).
Following type and result combinations are allowed:
\itemize{
\item STV, STE, STM, STH, STN, and mixed forms STE-M, STM-H
\item CTV, CTE, CTM, CTH, CTN, and mixed forms CTE-M, CTM-H
\item DTV, DTE, DTM, DTH, DTN, and mixed forms DTE-M, DTM-H
\item ECTPV, ECTP, ECTN, ECTX
\item RB, PST, DT tests are currently not supported.
}
\item \strong{score}: numeric, number of taps (for CT, ECT)
\item \strong{fract_char} corresponds to the fracture character, e.g., SP, SC, PC, RP, BRK, ...
\item \strong{depth}: vertical location of corresponding snowpack layer (from surface)
\item potential test comment column
}}

\item{dropNAs}{Should empty, non-mandatory columns be dropped from the final snowprofileTests object?}
}
\value{
snowprofileTests object
}
\description{
Create a snowprofileTests object.
}
\details{
For more information, see
Canadian Avalanche Association. (2016). Observation Guidelines and Recording Standards for Weather, Snowpack, and Avalanches (OGRS). Revelstoke, BC, Canada.
}
\examples{
## create a data.frame with test observations
(testsFrame <- data.frame(type = c("CT", "ST", "ECT"),
                         result = c("E-M", "M", "P"),
                         score = c(10, NA, 12),
                         fract_char = c("SP", NA, NA),
                         depth = c(40, 40, 40),
                         comment = c("some comment on first test", "", "")))

## create snowprofileTests object
tests <- snowprofileTests(testsFrame)

## create snowprofile object containing test results and check resulting object:
snowprofile(tests = tests)

}
\seealso{
\link{snowprofile}, \link{snowprofileLayers}, \link{snowprofileInstabilitySigns}
}
\author{
fherla
}
