% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/calcHistMatch.R
\docType{methods}
\name{calcHistMatch}
\alias{calcHistMatch}
\alias{calcHistMatch,RasterLayer-method}
\alias{calcHistMatch,RasterStack-method}
\alias{calcHistMatch,Satellite-method}
\title{Illumination correction across scenes using histogram matching}
\usage{
\S4method{calcHistMatch}{Satellite}(x, target, bcde = NULL, minv = 0L,
  maxv = 1023L, use_cpp = TRUE)

\S4method{calcHistMatch}{RasterStack}(x, target, minv = 0L, maxv = 1023L,
  use_cpp = TRUE)

\S4method{calcHistMatch}{RasterLayer}(x, target, minv = 0L, maxv = 1023L,
  use_cpp = TRUE)
}
\arguments{
\item{x}{Satellite or raster::Raster* object providing the source band(s) to
be adjusted.}

\item{target}{The target band as raster::RasterLayer.}

\item{bcde}{Band code which should be alligned}

\item{minv}{Lower limit of the possible range for transformation (if not
provided, defaults to the minimum of both layers).}

\item{maxv}{Upper limit of the possible range for transformation (if not
provided, defaults to the maximum of both layers).}

\item{use_cpp}{Logical. If \code{TRUE}, C++ functionality (via \strong{Rcpp})
is enabled, which leads to a considerable reduction of both computation time
and memory usage.}
}
\value{
Satellite object with added atmospheric corrected layers

raster::RasterStack object with atmospheric corrected layers

raster::RasterLayer object with atmospheric corrected layer
}
\description{
This function adjusts the illumination of individual bands across two scenes
using a histogram match.






}
\details{
The function is based on a histogram matching technique described
by Morovic et al. (2002).
}
\examples{
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC8*.tif"), full.names = TRUE)
sat <- satellite(files)
target <- getSatDataLayer(sat, "B003n")

\dontrun{
## histogram matching
calcHistMatch(sat, target, bcde = "B002n")
}
}
\references{
Morovic J, Shaw J, Sun P-L (2002) A fast, non-iterative and exact
histogram matching algorithm. Pattern Recognition Letters 23/1-3: 127-135,
doi:10.1016/S0167-8655(01)00107-6.
}

