% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satres.R
\name{get_spatial_resolution}
\alias{get_spatial_resolution}
\alias{get_spatial_resolution.satres}
\title{Get spatial resolutions}
\usage{
get_spatial_resolution(sr)

\method{get_spatial_resolution}{satres}(sr)
}
\arguments{
\item{sr}{A \code{satres} object.}
}
\value{
A vector of strings.
}
\description{
Returns the spatial resolutions of the multi-band raster that make up the object.
}
\examples{

esa <- system.file("extdata", "esa", package = "satres")
sr <- satres(dir = esa)

r <- sr |>
     get_spatial_resolution()

}
\seealso{
\code{\link{sat_untarzip}}

Other satellite definition: 
\code{\link{get_band_names}()},
\code{\link{get_spectral_band_names}()},
\code{\link{satres}()}
}
\concept{satellite definition}
