% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-SimpleSBM_sampler.R
\name{SimpleSBM_sampler}
\alias{SimpleSBM_sampler}
\title{R6 class for Simple SBM sampler}
\description{
R6 class for Simple SBM sampler

R6 class for Simple SBM sampler
}
\section{Super classes}{
\code{\link[sbm:SBM]{sbm::SBM}} -> \code{\link[sbm:SBM_sampler]{sbm::SBM_sampler}} -> \code{SimpleSBM_sampler}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{nbNodes}}{number of nodes}

\item{\code{nbBlocks}}{number of blocks}

\item{\code{nbDyads}}{number of dyads (potential edges in the network)}

\item{\code{memberships}}{vector of clustering}

\item{\code{indMemberships}}{matrix for clustering memberships}

\item{\code{expectation}}{expected values of connection under the current model}

\item{\code{directed}}{is the network directed or not}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SimpleSBM_sampler$new()}}
\item \href{#method-rMemberships}{\code{SimpleSBM_sampler$rMemberships()}}
\item \href{#method-rAdjacency}{\code{SimpleSBM_sampler$rAdjacency()}}
\item \href{#method-show}{\code{SimpleSBM_sampler$show()}}
\item \href{#method-clone}{\code{SimpleSBM_sampler$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="plot">}\href{../../sbm/html/SBM.html#method-plot}{\code{sbm::SBM$plot()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="print">}\href{../../sbm/html/SBM.html#method-print}{\code{sbm::SBM$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor for SBM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_sampler$new(
  model,
  nbNodes,
  directed,
  blockProp,
  connectParam,
  covarParam = numeric(0),
  covarList = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{character describing the type of model}

\item{\code{nbNodes}}{number of nodes in the network}

\item{\code{directed}}{logical, directed network or not.}

\item{\code{blockProp}}{parameters for block proportions (vector of list of vectors)}

\item{\code{connectParam}}{list of parameters for connectivity with a matrix of means 'mean' and an optional scalar for the variance 'var'. The size of mu must match \code{blockProp} length}

\item{\code{covarParam}}{optional vector of covariates effect}

\item{\code{covarList}}{optional list of covariates data}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rMemberships"></a>}}
\if{latex}{\out{\hypertarget{method-rMemberships}{}}}
\subsection{Method \code{rMemberships()}}{
a method to generate a vector of block indicators
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_sampler$rMemberships()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
nothing (sampled memberships is stored in the current object)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rAdjacency"></a>}}
\if{latex}{\out{\hypertarget{method-rAdjacency}{}}}
\subsection{Method \code{rAdjacency()}}{
a method to sample an adjacency matrix for the current SBM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_sampler$rAdjacency()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
nothing (sampled adjacency matrix is stored in the current object)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
show method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_sampler$show(type = "Sampler for a Simple Stochastic Block Model")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character used to specify the type of SBM}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SimpleSBM_sampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
