% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbo_predictions.R, R/sbo_predictor.R,
%   R/sbo_predtable.R
\name{sbo_predictions}
\alias{sbo_predictions}
\alias{sbo_predictor}
\alias{predictor}
\alias{sbo_predictor.character}
\alias{sbo_predictor.sbo_kgram_freqs}
\alias{sbo_predictor.sbo_predtable}
\alias{sbo_predtable}
\alias{predtable}
\alias{sbo_predtable.character}
\alias{sbo_predtable.sbo_kgram_freqs}
\title{Stupid Back-off text predictions}
\usage{
sbo_predictor(object, ...)

predictor(object, ...)

\method{sbo_predictor}{character}(
  object,
  N,
  dict,
  .preprocess = identity,
  EOS = "",
  lambda = 0.4,
  L = 3L,
  filtered = "<UNK>",
  ...
)

\method{sbo_predictor}{sbo_kgram_freqs}(object, lambda = 0.4, L = 3L, filtered = "<UNK>", ...)

\method{sbo_predictor}{sbo_predtable}(object, ...)

sbo_predtable(object, lambda = 0.4, L = 3L, filtered = "<UNK>", ...)

predtable(object, lambda = 0.4, L = 3L, filtered = "<UNK>", ...)

\method{sbo_predtable}{character}(
  object,
  lambda = 0.4,
  L = 3L,
  filtered = "<UNK>",
  N,
  dict,
  .preprocess = identity,
  EOS = "",
  ...
)

\method{sbo_predtable}{sbo_kgram_freqs}(object, lambda = 0.4, L = 3L, filtered = "<UNK>", ...)
}
\arguments{
\item{object}{either a character vector or an object inheriting from classes
\code{sbo_kgram_freqs} or \code{sbo_predtable}. Defines the method to use for
training.}

\item{...}{further arguments passed to or from other methods.}

\item{N}{a length one integer. Order 'N' of the N-gram model.}

\item{dict}{a \code{sbo_dictionary}, a character vector or a formula. For
more details see \code{\link[sbo]{kgram_freqs}}.}

\item{.preprocess}{a function for corpus preprocessing. For
more details see \code{\link[sbo]{kgram_freqs}}.}

\item{EOS}{a length one character vector. String listing End-Of-Sentence
characters. For more details see \code{\link[sbo]{kgram_freqs}}.}

\item{lambda}{a length one numeric. Penalization in the
Stupid Back-off algorithm.}

\item{L}{a length one integer. Maximum number of next-word predictions
for a given input (top scoring predictions are retained).}

\item{filtered}{a character vector. Words to exclude from next-word
predictions. The strings '<UNK>' and '<EOS>' are reserved keywords
referring to the Unknown-Word and End-Of-Sentence tokens, respectively.}
}
\value{
A \code{sbo_predictor} object for \code{sbo_predictor()}, a
\code{sbo_predtable} object for \code{sbo_predtable()}.
}
\description{
Train a text predictor via Stupid Back-off
}
\details{
These functions are generics used to train a text predictor
with Stupid Back-Off. The functions \code{predictor()} and
\code{predtable()} are aliases for \code{sbo_predictor()} and
\code{sbo_predtable()}, respectively.

The \code{sbo_predictor} data structure carries
all information
required for prediction in a compact and efficient (upon retrieval) way,
by directly storing the top \code{L} next-word predictions for each
k-gram prefix observed in the training corpus.

The \code{sbo_predictor} objects are for interactive use. If the training
process is computationally heavy, one can store a "raw" version of the
text predictor in a \code{sbo_predtable} class object, which can be safely
saved out of memory (with e.g. \code{save()}).
The resulting object can be restored
in another R session, and the corresponding \code{sbo_predictor} object
can be loaded rapidly using again the generic constructor
\code{sbo_predictor()} (see example below).

The returned objects are a \code{sbo_predictor} and a \code{sbo_predtable}
objects.
The latter contains Stupid Back-Off prediction tables, storing next-word
prediction for each k-gram prefix observed in the text, whereas the former
is an external pointer to an equivalent (but processed) C++ structure.

Both objects have the following attributes:
\itemize{
\item \code{N}: The order of the underlying N-gram model, "\code{N}".
\item \code{dict}: The model dictionary.
\item \code{lambda}: The penalization used in the Stupid Back-Off algorithm.
\item \code{L}: The maximum number of next-word predictions for a given text
input.
\item \code{.preprocess}: The function used for text preprocessing.
\item \code{EOS}: A length one character vector listing all (single character)
end-of-sentence tokens.
}
}
\examples{
\donttest{
# Train a text predictor directly from corpus
p <- sbo_predictor(twitter_train, N = 3, dict = max_size ~ 1000,
                   .preprocess = preprocess, EOS = ".?!:;")
}
\donttest{
# Train a text predictor from previously computed 'kgram_freqs' object
p <- sbo_predictor(twitter_freqs)
}
\donttest{
# Load a text predictor from a Stupid Back-Off prediction table
p <- sbo_predictor(twitter_predtable)
}
\donttest{
# Predict from Stupid Back-Off text predictor
p <- sbo_predictor(twitter_predtable)
predict(p, "i love")
}
\donttest{
# Build Stupid Back-Off prediction tables directly from corpus
t <- sbo_predtable(twitter_train, N = 3, dict = max_size ~ 1000, 
                   .preprocess = preprocess, EOS = ".?!:;")
}
\donttest{
# Build Stupid Back-Off prediction tables from kgram_freqs object
t <- sbo_predtable(twitter_freqs)
}
\dontrun{
# Save and reload a 'sbo_predtable' object with base::save()
save(t)
load("t.rda")
}
}
\seealso{
\code{\link[sbo]{predict.sbo_predictor}}
}
\author{
Valerio Gherardi
}
