% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_plots.r
\name{plot_heatmap_tc}
\alias{plot_heatmap_tc}
\title{Plot time courses organised as data frame columns with a heatmap.}
\usage{
plot_heatmap_tc(df, g = ggplot(), scaled = TRUE, title = "",
  xaxis_label = "", yaxis_label = "")
}
\arguments{
\item{df}{a data frame, with Time as first column}

\item{g}{the current ggplot to overlap}

\item{scaled}{TRUE if the time course values should be scaled within 0 and 1.}

\item{title}{the title of the plot}

\item{xaxis_label}{the xaxis label of the plot}

\item{yaxis_label}{the yaxis label of the plot}
}
\value{
the plot
}
\description{
Plot time courses organised as data frame columns with a heatmap.
}
\examples{
data(insulin_receptor_1)
data(insulin_receptor_2)
data(insulin_receptor_3)
df <- data.frame(Time=insulin_receptor_1[,1], 
                 X1=insulin_receptor_1[,2], 
                 X2=insulin_receptor_2[,2], 
                 X3=insulin_receptor_3[,2])
plot_heatmap_tc(df=df, scaled=FALSE, xaxis_label="Time [m]", yaxis_label="repeats")
plot_heatmap_tc(df=df, scaled=TRUE, xaxis_label="Time [m]", yaxis_label="repeats")
}
