% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Object_Utilities.R
\name{Store_Misc_Info_Seurat}
\alias{Store_Misc_Info_Seurat}
\title{Store misc data in Seurat object}
\usage{
Store_Misc_Info_Seurat(
  seurat_object,
  data_to_store,
  data_name,
  list_as_list = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{seurat_object}{object name.}

\item{data_to_store}{data to be stored in \verb{@misc} slot.  Can be single piece of data or list.
If list of data see \code{list_as_list} parameter for control over data storage.}

\item{data_name}{name to give the entry in \verb{@misc} slot.  Must be of equal length of the number
of data items being stored.}

\item{list_as_list}{logical.  If \code{data_to_store} is a list, this dictates whether to store in \verb{@misc} slot
as list (TRUE) or whether to store each entry in the list separately (FALSE).  Default is FALSE.}

\item{overwrite}{Logical.  Whether to overwrite existing items with the same name.  Default is FALSE, meaning
that function will abort if item with \code{data_name} is present in misc slot.}
}
\value{
Seurat Object with new entries in the \verb{@misc} slot.
}
\description{
Wrapper function save variety of data types to the \code{object@misc} slot of Seurat object.
}
\examples{
library(Seurat)
clu_pal <- c("red", "green", "blue")

pbmc_small <- Store_Misc_Info_Seurat(seurat_object = pbmc_small, data_to_store = clu_pal,
data_name = "rd1_colors")

}
\concept{get_set_util}
