% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{plotCellTypeSankey}
\alias{plotCellTypeSankey}
\title{plot Sankey diagram for cell type links above a certain threshould}
\usage{
plotCellTypeSankey(corr_matrix, corr_threshould = 0.1, ...)
}
\arguments{
\item{corr_matrix}{cell type corr matrix from crossSpeciesCellTypeGOCorr}

\item{corr_threshould}{minimum corr value for positively related cell types, default 0.6}

\item{...}{additional params for sankeyNetwork}
}
\value{
a Sankey plot showing related cell types
}
\description{
plot Sankey diagram for cell type links above a certain threshould
}
\examples{
\donttest{
library(scGOclust)
library(httr)
httr::set_config(httr::config(ssl_verifypeer = FALSE))
mmu_tbl = ensemblToGo(species = 'mmusculus')
data(mmu_subset)
go_seurat_obj = makeGOSeurat(ensembl_to_GO = mmu_tbl,
 seurat_obj = mmu_subset,
 feature_type = "external_gene_name")

cell_type_go = getCellTypeGO(go_seurat_obj = go_seurat_obj, cell_type_co = "cell_type_annotation")
corr_matrix = cellTypeGOCorr(cell_type_go = cell_type_go, corr_method = "pearson")

plotCellTypeSankey(corr_matrix = corr_matrix, 0.1)
}
}
