% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{combine_scGate_multiclass}
\alias{combine_scGate_multiclass}
\title{Combine scGate annotations}
\usage{
combine_scGate_multiclass(
  obj,
  prefix = "is.pure_",
  scGate_classes = NULL,
  min_cells = 1,
  multi.asNA = FALSE,
  out_column = "scGate_multi"
)
}
\arguments{
\item{obj}{Seurat object with scGate results for multiple models stored as metadata}

\item{prefix}{Prefix in metadata column names for scGate result models}

\item{scGate_classes}{Vector of scGate model names. If NULL, use all columns that start with "prefix" above.}

\item{min_cells}{Minimum number of cells for a cell label to be considered}

\item{multi.asNA}{How to label cells that are "Pure" for multiple annotations: "Multi" (FALSE) or NA (TRUE)}

\item{out_column}{The name of the metadata column where to store the multi-class cell labels}
}
\value{
A Seurat object with multi-class annotations based on the combination of multiple models. A new
     column (by default "scGate_multi") is added to the metadata of the Seurat object.
}
\description{
If a single-cell dataset has precomputed results for multiple scGate models, combined them in multi-class annotation
}
\examples{
\donttest{
# Define gating models
model.B <- gating_model(name = "Bcell", signature = c("MS4A1")) 
model.T <- gating_model(name = "Tcell", signature = c("CD2","CD3D","CD3E"))
# Apply scGate with these models
data(query.seurat)
query.seurat <- scGate(query.seurat, model=model.T,
    reduction="pca", output.col.name = "is.pure_Tcell")
query.seurat <- scGate(query.seurat, model=model.B,
    reduction="pca", output.col.name = "is.pure_Bcell")
query.seurat <- combine_scGate_multiclass(query.seurat, scGate_class=c("Tcell","Bcell"))      
table(query.seurat$scGate_multi)
}
}
