% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{lisi}
\alias{lisi}
\title{Compute Local Inverse Simpson's Index (LISI)}
\usage{
lisi(X, meta_data, label_colnames, perplexity = 30, nn_eps = 0)
}
\arguments{
\item{X}{A matrix with cells (rows) and features (columns).}

\item{meta_data}{A data frame with one row per cell.}

\item{label_colnames}{Which variables to compute LISI for.}

\item{perplexity}{The effective number of each cell's neighbors.}

\item{nn_eps}{Error bound for nearest neighbor search with \code{RANN:nn2()}.
Default of 0.0 implies exact nearest neighbor search.}
}
\value{
A data frame of LISI values. Each row is a cell and each
column is a different label variable.
}
\description{
Use this function to compute LISI scores of one or more labels.
}
\examples{
data(sceiad_subset_data)
features <- sceiad_subset_data[, paste0('scviDim_', 1:8)]
metadata <- sceiad_subset_data[,c('Barcode', 'cluster',  'subcluster',
                                     'CellType', 'CellType_predict')]
lisi_scores <- lisi(features, metadata, c('CellType_predict'))
head(lisi_scores)

}
