% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_helper.R
\name{getScalpel}
\alias{getScalpel}
\title{Read in results from SCALPEL.}
\usage{
getScalpel(
  outputFolder,
  version = NULL,
  cutoff = 0.18,
  omega = 0.2,
  lambdaMethod = "trainval",
  lambda = NULL,
  minClusterSize = 1,
  alpha = 0.9,
  removeBorder = FALSE,
  excludeReps = NULL
)
}
\arguments{
\item{outputFolder}{The existing directory where the results that the user wishes to use are saved.}

\item{version}{The 5-digit folder ID for the results that the user wishes to load. If NULL, automatically chooses
the only version in outputFolder and if more than one version exists, returns an error.}

\item{cutoff}{A value in [0,1] indicating the dendrogram cutpoint used. The default value is 0.18.}

\item{omega}{A value in [0,1] indicating the dissimilarity metric weight used for clustering. The default value is 0.2.}

\item{lambdaMethod}{How lambda was chosen: either \code{"trainval"} (default), \code{"distn"}, or \code{"user"}.}

\item{lambda}{The value of lambda used to fit the sparse group lasso. If NULL, automatically chooses
the only lambda in directory and if more than one lambda exists, returns an error.}

\item{minClusterSize}{The minimum number of preliminary dictionary elements that a cluster must have contained to have been included
in the sparse group lasso. The default value is 1.}

\item{alpha}{The value of alpha used to fit the sparse group lasso. The default value is 0.9.}

\item{removeBorder}{A logical scalar indicating whether the dictionary elements that contained pixels in the 10-pixel
border of the video were removed prior to fitting the sparse group lasso. The default value is \code{FALSE}.}

\item{excludeReps}{A vector giving the indices of which dictionary elements were excluded.
The default value is \code{NULL} meaning no dictionary elements were manually excluded.}
}
\value{
An object of class \code{scalpel}, which can be used to rerun SCALPEL Steps 1-3 with new parameters using \code{\link{scalpelStep1}}, \code{\link{scalpelStep2}}, and \code{\link{scalpelStep3}}
or can be used with any of the plotting functions: \code{\link{plotFrame}}, \code{\link{plotThresholdedFrame}}, \code{\link{plotVideoVariance}}, \code{\link{plotCandidateFrame}},
\code{\link{plotCluster}}, \code{\link{plotResults}}, \code{\link{plotResultsAllLambda}}, \code{\link{plotSpatial}},
\code{\link{plotTemporal}}, and \code{\link{plotBrightest}}.
}
\description{
This step allows the user to retrieve the object of class \code{scalpel} for results from a previous session.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function
#folder where results were saved
outputFolder = "scalpelResults"

#read previous results in
#simplest example with default parameters:
out = getScalpel(outputFolder = outputFolder)
#note: if Step 1 has been run more than once, will need to specify 'version'

#example with optional parameters:
#need to enter if non-default options were used
out = getScalpel(outputFolder = outputFolder, omega = 0.2, cutoff = 0.18,
                alpha = 0.9, minClusterSize = 1)
}
}
\seealso{
\code{\link{scalpel}}
}
