% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothSC.R
\name{smoothSC}
\alias{smoothSC}
\title{Smoothing single-case data}
\usage{
smoothSC(data, dvar, mvar, FUN = "movingMedian", intensity = NULL)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about this format.}

\item{dvar}{Character string with the name of the dependent variable. Defaults to the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable. Defaults to the attributes in the scdf file.}

\item{FUN}{Function determining the smoothed scores. Default \code{FUN =
"movingMedian"} is a moving Median function. Further possible values are:
\code{"movingMean"} and a non-parametric \code{"localRegression"}.}

\item{intensity}{For \code{FUN = "movingMedian"} and \code{"movingMean"} it
is the lag used for computing the average. Default is \code{intensity = 1}.
In case of \code{FUN = "localRegression"} it is the proportion of
surrounding data influencing each data point, which is \code{intensity =
0.2} by default.}
}
\value{
Returns a data frame (for each single-case) with smoothed data
points. See \code{\link{scdf}} to learn about the format of these data
frames.
}
\description{
The \code{smoothSC} function provides procedures to smooth single-case data
(i.e., to eliminate noise). A moving average function (mean- or
median-based) replaces each data point by the average of the surrounding
data points step-by-step. With a local regression function, each data point
is regressed by its surrounding data points.
}
\examples{

## Use the three different smoothing functions and compare the results
study <- c(
 "Original"         = Huber2014$Berta,
 "Moving Median"    = smoothSC(Huber2014$Berta, FUN = "movingMedian"),
 "Moving Mean"      = smoothSC(Huber2014$Berta, FUN = "movingMean"),
 "Local Regression" = smoothSC(Huber2014$Berta, FUN = "localRegression")
)
plot(study)

}
\seealso{
Other data manipulation functions: \code{\link{fillmissingSC}},
  \code{\link{longSCDF}}, \code{\link{outlierSC}},
  \code{\link{rankSC}}, \code{\link{scaleSC}},
  \code{\link{shiftSC}}, \code{\link{truncateSC}}
}
\author{
Juergen Wilbert
}
\concept{data manipulation functions}
\keyword{manip}
