% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe.R
\name{describe}
\alias{describe}
\title{Descriptive statistics for single-case data}
\usage{
describe(data, dvar, pvar, mvar)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}
}
\value{
A list containing a data frame of descriptive statistics
(descriptives); the cse design (design); the number of cases (N)
}
\description{
The \code{describe()} function provides common descriptive statistics for
single-case data.
}
\details{
n = number of measurements; mis = number of missing vaues; m = mean;
md = median; sd = standard deviation; mad = median average deviation; min =
minimum; max = maximum; trend = weight of depended variable regressed on
time (values ~ mt).
}
\examples{

## Descriptive statistics for a study of three single-cases
describe(Grosche2011)

## Descriptives of a three phase design
describe(exampleABC)

## Write descriptive statistics to .csv-file
study <- describe(Waddell2011)
write.csv(study$descriptives, file = tempfile())
}
\seealso{
\code{\link[=overlap]{overlap()}}, \code{\link[=plot.scdf]{plot.scdf()}}
}
\author{
Juergen Wilbert
}
