% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_negbin.R
\name{negbin_increasing_calculations}
\alias{negbin_increasing_calculations}
\title{Calculate the increasing score for each space-time window.}
\usage{
negbin_increasing_calculations(table, zones)
}
\arguments{
\item{table}{A \code{data.table} with columns \code{location, duration, mu,
theta, count}. The \code{location} column should consist of integers that 
are unique to each location. The \code{duration} column should also 
consist of integers, starting at 1 for the most recent time period and 
increasing in reverse chronological order. 

A negative binomial distribution parametrized by \eqn{\mu} and 
\eqn{\theta} (columns \code{mu} and \code{theta} respectively) has 
expected value \eqn{\mu} and variance \eqn{\mu+\mu^2/\theta}. The 
parameter \eqn{\theta} is referred to as the \code{size} in 
\code{\link[stats]{NegBinomial}}, and \code{theta} in 
\code{\link[MASS]{negative.binomial}}.}

\item{zones}{A \code{set} of zones, each zone itself a 
set containing one or more locations of those found in \code{table}.}
}
\value{
A \code{data.table} with columns \code{zone, duration, statistic}.
}
\description{
Calculate the increasing score for each space-time window, given the initial 
data of counts, expected values, and overdispersion parameters.
}
\keyword{internal}

