% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{scan_eb_zip_cpp}
\alias{scan_eb_zip_cpp}
\title{Calculate the highest-value EB ZIP loglihood ratio statistic.}
\usage{
scan_eb_zip_cpp(counts, baselines, probs, zones, zone_lengths, rel_tol,
  store_everything, num_mcsim)
}
\arguments{
\item{counts}{matrix (most recent timepoint in first row)}

\item{baselines}{matrix (most recent timepoint in first row)}

\item{probs}{matrix (most recent timepoint in first row)}

\item{zones}{integer vector (all zones concatenated; locations indexed from
0 and up)}

\item{zone_lengths}{integer vector}

\item{rel_tol}{double}

\item{store_everything}{boolean}

\item{num_mcsim}{int}
}
\value{
A list with elements \code{observed} and \code{simulated}, each 
   being a data frame with columns:
   \describe{
     \item{zone}{The top-scoring zone (spatial component of MLC).}
     \item{duration}{The corresponding duration (time-length of MLC).}
     \item{score}{The value of the loglihood ratio statistic (the scan
                  statistic).}
     \item{relrisk}{The estimated relative risk.}
     \item{n_iter}{The number of iterations performed by the EM algorithm.}
   }
}
\description{
Calculate the expectation-based ZIP loglihood ratio statistic for each zone
and duration, but only keep the zone and duration with the highest value
(the MLC). The estimate of the relative risk is also calculated, along with
the number of iterations the EM algorithm performed.
}
\keyword{internal}
