% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scPathway.R
\name{scPathway}
\alias{scPathway}
\title{Infer pathway activation score matrix at single-cell resolution}
\usage{
scPathway(
  network.data,
  gmt.path = NULL,
  pathway.min = 10,
  pathway.max = 500,
  nperm = 100,
  parallel.cores = 2,
  rwr.gamma = 0.7,
  verbose = TRUE
)
}
\arguments{
\item{network.data}{The input network data is the result from the \code{ConNetGNN} function.}

\item{gmt.path}{Pathway database in \code{GMT} format.}

\item{pathway.min}{Minimum size (in genes) for pathway to be considered. Default: \code{10}.}

\item{pathway.max}{Maximum size (in genes) for database gene sets to be considered. Default: \code{500}.}

\item{nperm}{Number of random permutations. Default: \code{100}.}

\item{parallel.cores}{Number of processors to use when doing the calculations in parallel (default: \code{2}). If \code{parallel.cores=0}, then it will use all available core processors unless we set this argument with a smaller number.}

\item{rwr.gamma}{Restart parameter. Default: \code{0.7}.}

\item{verbose}{Gives information about each step. Default: \code{TRUE}.}
}
\value{
A matrix of single-cell pathway activity score.
}
\description{
Calculate pathway activity score of single-cell by random walk with restart (RWR).
}
\details{
scPathway


The \code{scPathway} function integrates the results of ConNetGNN into a gene-cell association network.
The genes included in each pathway are used as a restart set in the gene-cell association network to calculate the strength of its association with each cell through \code{RWR}.
Perturbation analysis was performed to remove noise effects in the network and to obtain the final single-cell pathway activity score matrix.
}
\examples{
require(parallel)
require(utils)
# Load the result of the ConNetGNN function.
data(ConNetGNN_data)
kegg.path<-system.file("extdata", "KEGG_human.gmt", package = "scapGNN")
scPathway_data<-scPathway(ConNetGNN_data,gmt.path=kegg.path,
                          pathway.min=25,nperm=6,parallel.cores=1)

}
