% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scattermore.R
\name{geom_scattermore}
\alias{geom_scattermore}
\title{geom_scattermore}
\usage{
geom_scattermore(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", ..., na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, interpolate = FALSE, pointsize = 0,
  pixels = c(512, 512))
}
\arguments{
\item{mapping, data, stat, position, inherit.aes, show.legend, ...}{passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}}

\item{na.rm}{Remove NA values, just as with \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.}

\item{interpolate}{Default FALSE, passed to \code{\link[grid:rasterGrob]{grid::rasterGrob()}}.}

\item{pointsize}{Radius of rasterized point. Use \code{0} for single pixels (fastest).}

\item{pixels}{Vector with X and Y resolution of the raster, default \code{c(512,512)}.}
}
\description{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} integration. This cooperates with the rest of ggplot
(so you can use it to e.g. add rasterized scatterplots to vector output in
order to reduce PDF size). Note that the ggplot processing overhead still dominates
the plotting time. Use \code{\link[=geom_scattermost]{geom_scattermost()}} to tradeoff some niceness and
circumvent ggplot logic to gain speed.
}
\details{
Accepts aesthetics \code{x}, \code{y}, \code{colour} and \code{alpha}. Point size is fixed for
all points. Due to rasterization properties it is often beneficial to try
non-integer point sizes, e.g. \code{3.2} looks much better than \code{3}.
}
\examples{
library(ggplot2)
library(scattermore)
ggplot(data.frame(x=rnorm(100000), y=rexp(100000))) +
  geom_scattermore(aes(x,y,color=x),
                   pointsize=3,
                   alpha=0.1,
                   pixels=c(1000,1000),
                   interpolate=TRUE) +
  scale_color_viridis_c()
}
