% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_functions.R
\name{readExperimentFile}
\alias{readExperimentFile}
\title{Read data from an experiment-like file}
\usage{
readExperimentFile(file, alg.col, value.col, col.names = NULL, ...)
}
\arguments{
\item{file}{Path to the file to read.}

\item{alg.col}{Name or index of the column corresponding to the algorithm used in the experiment.}

\item{value.col}{Name or index of the column corresponding to the numerical result of the experiment.}

\item{col.names}{Vector of names for the columns. If not provided (or \code{NULL}) the names will be read from the first line of the file.}

\item{...}{Additional parameters for the read.csv function used to load the data. It can be used, for example, to set the separator (e.g., \code{sep="\t"}). Note that the \code{header} argument is automatically set according to the \code{col.names} argument.}
}
\value{
A data.frame where each column represents either a feature of the experiment or the result of running an algorithm. Algorithm columns are placed always at the end of the table.
}
\description{
This function reads the data from a file where each row is an experiment characterized by some variables (one of which should be the algorithm used) and with one and only one numeric result. For files where there is more than one result per line see \code{\link{readComparisonFile}}.
}
\examples{
dir <- system.file("loading_tests",package="scmamp")
file <- paste(dir , "rgg_complete_experiment.out" , sep="/")
data <- readExperimentFile (file=file, alg.col="Algorithm", value.col="Evaluation")
dim(data)
head(data)
}
\seealso{
\code{\link{readExperimentDir}}, \code{\link{readComparisonFile}}, \code{\link{readComparisonDir}}  and the vignette \code{vignette(topic="Data_loading_and_manipulation", package="scmamp")}
}

