% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twins.R
\name{twins}
\alias{twins}
\title{Twins}
\usage{
twins(xf, xnf, yf)
}
\arguments{
\item{xf}{The matrix of financed clients' characteristics to be used in the scorecard.}

\item{xnf}{The matrix of not financed clients' characteristics to be used in the scorecard (must be the same in the same order as xf!).}

\item{yf}{The matrix of financed clients' labels}
}
\value{
List containing the model using financed clients only, the model of acceptance and the model produced using the Twins method.
}
\description{
This function performs Reject Inference using the Twins technique. Note that this technique has no theoretical foundation.
}
\details{
This function performs the Twins method on the data. When provided with labeled observations \eqn{(x^\ell,y)}, it first fits the logistic regression model \eqn{p_\theta} of
\eqn{x^\ell} on \eqn{y}, then fits the logistic regression model \eqn{p_\omega} of \eqn{X} on the binomial random variable denoting the observation of the data \eqn{Z}.
We use predictions of both models on the labeled observations to construct a "meta"-score based on logistic regression which predicted probabilities are used to reweight samples and construct the final score \eqn{p_\eta}.
}
\examples{
# We simulate data from financed clients
df <- generate_data(n = 100, d = 2)
xf <- df[, -ncol(df)]
yf <- df$y
# We simulate data from not financed clients (MCAR mechanism)
xnf <- generate_data(n = 100, d = 2)[, -ncol(df)]
twins(xf, xnf, yf)
}
\references{
Enea, M. (2015), speedglm: Fitting Linear and Generalized Linear Models to Large Data Sets, \url{https://CRAN.R-project.org/package=speedglm}
Ehrhardt, A., Biernacki, C., Vandewalle, V., Heinrich, P. and Beben, S. (2018), Reject Inference Methods in Credit Scoring: a rational review,
}
\seealso{
\code{glm}, \code{speedglm}
}
\author{
Adrien Ehrhardt
}
\keyword{credit}
\keyword{inference}
\keyword{reject}
\keyword{réintégration}
\keyword{scorecard}
\keyword{scoring}
