% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pit.R
\name{pit}
\alias{pit}
\title{Probability Integral Transformation (data.frame Format)}
\usage{
pit(data, by, n_replicates = 100)
}
\arguments{
\item{data}{a data.frame with the following columns: \code{true_value},
\code{prediction}, \code{sample}.}

\item{by}{Character vector with the columns according to which the
PIT values shall be grouped. If you e.g. have the columns 'model' and
'location' in the data and want to have a PIT histogram for
every model and location, specify \code{by = c("model", "location")}.}

\item{n_replicates}{the number of draws for the randomised PIT for
integer predictions.}
}
\value{
a data.table with PIT values according to the grouping specified in
\code{by}
}
\description{
Wrapper around \code{pit()} for use in data.frames
}
\details{
see \code{\link[=pit]{pit()}}
}
\examples{
result <- pit(example_continuous, by = "model")
plot_pit(result)

# example with quantile data
result <- pit(example_quantile, by = "model")
plot_pit(result)
}
\references{
Sebastian Funk, Anton Camacho, Adam J. Kucharski, Rachel Lowe,
Rosalind M. Eggo, W. John Edmunds (2019) Assessing the performance of
real-time epidemic forecasts: A case study of Ebola in the Western Area
region of Sierra Leone, 2014-15, \doi{10.1371/journal.pcbi.1006785}
}
\keyword{scoring}
