% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience-functions.R
\name{set_forecast_unit}
\alias{set_forecast_unit}
\title{Set unit of a single forecast manually}
\usage{
set_forecast_unit(data, forecast_unit)
}
\arguments{
\item{data}{A data.frame or data.table with the predictions and observations.
For scoring using \code{\link[=score]{score()}}, the following columns need to be present:
\itemize{
\item \code{true_value} - the true observed values
\item \code{prediction} - predictions or predictive samples for one
true value. (You only don't need to provide a prediction column if
you want to score quantile forecasts in a wide range format.)}
For scoring integer and continuous forecasts a \code{sample} column is needed:
\itemize{
\item \code{sample} - an index to identify the predictive samples in the
prediction column generated by one model for one true value. Only
necessary for continuous and integer forecasts, not for
binary predictions.}
For scoring predictions in a quantile-format forecast you should provide
a column called \code{quantile}:
\itemize{
\item \code{quantile}: quantile to which the prediction corresponds
}

In addition a \code{model} column is suggested and if not present this will be
flagged and added to the input data with all forecasts assigned as an
"unspecified model").

You can check the format of your data using \code{\link[=check_forecasts]{check_forecasts()}} and there
are examples for each format (\link{example_quantile}, \link{example_continuous},
\link{example_integer}, and \link{example_binary}).}

\item{forecast_unit}{Character vector with the names of the columns that
uniquely identify a single forecast.}
}
\value{
A data.table with only those columns kept that are relevant to
scoring or denote the unit of a single forecast as specified by the user.
}
\description{
Helper function to set the unit of a single forecast (i.e. the
combination of columns that uniquely define a single forecast) manually.
This simple function keeps the columns specified in \code{forecast_unit} (plus
additional protected columns, e.g. for true values, predictions or quantile
levels) and removes duplicate rows.
If not done manually, \code{scoringutils} attempts to determine the unit
of a single forecast automatically by simply assuming that all column names
are relevant to determine the forecast unit. This may lead to unexpected
behaviour, so setting the forecast unit explicitly can help make the code
easier to debug and easier to read. When used as part of a workflow,
\code{set_forecast_unit()} can be directly piped into \code{check_forecasts()} to
check everything is in order.
}
\examples{
set_forecast_unit(
  example_quantile,
  c("location", "target_end_date", "target_type", "horizon", "model")
)
}
\keyword{data-handling}
