% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-correlations.R
\name{plot_correlations}
\alias{plot_correlations}
\title{Plot correlation between metrics}
\usage{
plot_correlations(correlations, digits = NULL)
}
\arguments{
\item{correlations}{A data.table of correlations between scores as produced
by \code{\link[=get_correlations]{get_correlations()}}.}

\item{digits}{A number indicating how many decimal places the correlations
should be rounded to. By default (\code{digits = NULL}) no rounding takes place.}
}
\value{
A ggplot object showing a coloured matrix of correlations between metrics.

A ggplot object with a visualisation of correlations between metrics
}
\description{
Plots a heatmap of correlations between different metrics.
}
\examples{
library(magrittr) # pipe operator
scores <- example_quantile \%>\%
  as_forecast_quantile \%>\%
  score()
correlations <- scores \%>\%
  summarise_scores() \%>\%
  get_correlations()
plot_correlations(correlations, digits = 2)
}
