% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background_panel.R
\name{set_background}
\alias{set_background}
\alias{set_panel}
\title{Set plot and panel background of an scplot}
\usage{
set_background(object, ...)

set_panel(object, ...)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{...}{List with rectangle parameters (\verb{"fill", "colour", "linewidth", "linetype"}). See \code{\link[=element_rect]{element_rect()}}.}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}).
}
\description{
Set plot and panel background of an scplot
}
\examples{
data(exampleAB, package = "scan")
p1 <- scplot(exampleAB)  |>
 set_background(fill = "lightblue", colour = "darkblue", linewidth = 1.5) |>
 set_panel(fill = "deepskyblue", color = "darkblue", linewidth = 0.3)
}
