% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locat_image.R
\name{locate_image}
\alias{locate_image}
\title{Locate needle image position on a screenshot image.}
\usage{
locate_image(
  needle_image,
  center = TRUE,
  exact = TRUE,
  timeout = 5,
  bin_dir = ""
)
}
\arguments{
\item{needle_image}{A string of image file path or
a cimg class object of imager library.}

\item{center}{A logical. TRUE returns center position of needle_image.}

\item{exact}{A logical. Check matching exactly or not.}

\item{timeout}{A numeric for timeout seconds.}

\item{bin_dir}{A string for directory name of screenshot.exe on Win.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   A numeric pair of xy location.
}\if{html}{\out{</div>}}
}
\description{
Locate needle image position on a screenshot image.
}
\examples{
if(interactive()){

sc <- screenshot()
if(sc != ""){
  sc_image <- imager::load.image(sc)
  w <- 100
  h <- 80
  pos_x <- 1
  pos_y <- imager::height(sc_image) - h
  needle <- hay2needle(sc_image, pos_x, pos_y, w, h)
  (locate_image(needle)) # center location
  pos <- locate_image(needle, center = FALSE)
  found <- hay2needle(sc_image, pos[1], pos[2], w, h)
  layout(c(1:3))
  plot(sc_image)
  plot(needle)
  plot(found)
}

}

}
