% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapper-function-helpers.R
\name{unnest_consistency_cols}
\alias{unnest_consistency_cols}
\title{Unnest a test result column}
\usage{
unnest_consistency_cols(results, col_names, index = FALSE, col = "consistency")
}
\arguments{
\item{results}{Data frame containing a list-column by the name passed to
\code{col}.}

\item{col_names}{String vector of new names for the unnested columns. It
should start with the same string that was given for \code{col}.}

\item{index}{Boolean. Should the list-column be indexed into? Default is
\code{FALSE}.}

\item{col}{String (length 1). Name of the list-column within \code{results} to
operate on. Default is \code{"consistency"}.}
}
\value{
Data frame. The column names are determined by \code{col_names}.
}
\description{
Within a consistency test mapper function, it may become
necessary to unpack a column resulting from a basic \verb{*_scalar()} testing
function. That will be the case if the a \verb{show_*} argument of the mapper
function is \code{TRUE}, and the \verb{*_scalar()} function returns a list of values,
not just a single value.

At the point where such as list is stored in a data frame column (most
likely \code{"consistency"}), call \code{unnest_consistency_cols()} to unnest the
results into multiple columns.
}
\details{
This function is a custom workaround in place of
\code{tidyr::unnest_wider()}, mirroring some of the latter's functionality. It
was created because \code{unnest_wider()} can be too slow for use as a helper
function.
}
\seealso{
\code{vignette("consistency-tests")}, for context.
}
