% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit.R
\name{audit}
\alias{audit}
\title{Summarize scrutiny objects}
\usage{
audit(data)
}
\arguments{
\item{data}{A data frame that inherits one of the classes named below.}
}
\value{
A tibble (data frame) with test summary statistics.
}
\description{
\code{audit()} summarizes the results of scrutiny functions like
\code{grim_map()} that perform tests on data frames.

See below for a record of such functions. Go to the documentation of any of
them to learn about its \code{audit()} method.
}
\details{
\code{audit()} is an S3 generic.
}
\section{Before \code{audit()}}{
\tabular{ll}{
   \strong{Function} \tab \strong{Class} \cr
   \code{grim_map()} \tab \code{"scr_grim_map"} \cr
   \code{grimmer_map()} \tab \code{"scr_grimmer_map"} \cr
   \code{debit_map()} \tab \code{"scr_debit_map"} \cr
   \code{duplicate_count()} \tab \code{"scr_dup_count"} \cr
   \code{duplicate_count_colpair()} \tab \code{"scr_dup_count_colpair"} \cr
   \code{duplicate_detect()} \tab \code{"scr_dup_detect"} \cr
   \code{audit_seq()} \tab \code{"scr_audit_seq"} \cr
   \code{audit_total_n()} \tab \code{"scr_audit_total_n"} \cr
}
}

\examples{
# For basic GRIM-testing:
pigs1 \%>\%
  grim_map() \%>\%
  audit()

# For duplicate detection:
pigs4 \%>\%
  duplicate_detect() \%>\%
  audit()
}
