% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{compare_expression}
\alias{compare_expression}
\title{Compare gene expression between two groups}
\usage{
compare_expression(x, umi, group, val1, val2, method = "LRT",
  bin_size = 256, cell_attr = x$cell_attr, y = x$y, min_cells = 5,
  weighted = TRUE, randomize = FALSE, show_progress = TRUE)
}
\arguments{
\item{x}{A list that provides model parameters and optionally meta data; use output of vst function}

\item{umi}{A matrix of UMI counts with genes as rows and cells as columns}

\item{group}{A vector indicating the groups}

\item{val1}{A vector indicating the values of the group vector to treat as group 1}

\item{val2}{A vector indicating the values of the group vector to treat as group 2}

\item{method}{Either 'LRT' for likelihood ratio test, or 't_test' for t-test}

\item{bin_size}{Number of genes that are processed between updates of progress bar}

\item{cell_attr}{Data frame of cell meta data}

\item{y}{Only used if methtod = 't_test', this is the residual matrix; default is x$y}

\item{min_cells}{A gene has to be detected in at least this many cells in at least one of the groups being compared to be tested}

\item{weighted}{Balance the groups by using the appropriate weights}

\item{randomize}{Boolean indicating whether to shuffle group labels - only set to TRUE when testing methods}

\item{show_progress}{Show progress bar}
}
\value{
Data frame of results
}
\description{
Compare gene expression between two groups
}
\examples{
\dontrun{
vst_out <- vst(pbmc, return_cell_attr = TRUE)
# create fake clusters
clustering <- 1:ncol(pbmc) \%/\% 100
res <- compare_expression(x = vst_out, umi = pbmc, group = clustering, val1 = 0, val2 = 3)
}

}
