% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_model_var}
\alias{get_model_var}
\title{Return average variance under negative binomial model}
\usage{
get_model_var(
  vst_out,
  cell_attr = vst_out$cell_attr,
  use_nonreg = FALSE,
  bin_size = 256,
  verbosity = 2,
  verbose = TRUE,
  show_progress = TRUE
)
}
\arguments{
\item{vst_out}{The output of a vst run}

\item{cell_attr}{Data frame of cell meta data}

\item{use_nonreg}{Use the non-regularized parameter estimates; boolean; default is FALSE}

\item{bin_size}{Number of genes to put in each bin (to show progress)}

\item{verbosity}{An integer specifying whether to show only messages (1), messages and progress bars (2) or nothing (0) while the function is running; default is 2}

\item{verbose}{Deprecated; use verbosity instead}

\item{show_progress}{Deprecated; use verbosity instead}
}
\value{
A named vector of variances (the average across all cells), one entry per gene.
}
\description{
This is based on the formula var = mu + mu^2 / theta
}
\examples{
\dontrun{
vst_out <- vst(pbmc)
res_var <- get_model_var(vst_out)
}

}
