% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_nodenames.R
\name{hier_nodenames}
\alias{hier_nodenames}
\title{Extract name of nodes (levels)}
\usage{
hier_nodenames(tree, root = NULL)
}
\arguments{
\item{tree}{a (nested) hierarchy created using \code{\link{hier_create}}
or modified using \code{\link{hier_add}}, \code{\link{hier_delete}}
or \code{\link{hier_rename}}.}

\item{root}{(character) name of start node from which all lower
level-names should be returned}
}
\description{
This function allows to extract the all the names of the
nodes including all (sub)-nodes and leaves in the given
hierarchy.
}
\examples{
h <- hier_create(root = "Total",  nodes = LETTERS[1:3])
h <- hier_add(h, root = "A", nodes = c("a1", "a5"))
hier_nodenames(h)
}
