% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_cutList.r, R/methods_class_cutList.r
\docType{methods}
\name{init.cutList}
\alias{init.cutList}
\alias{init.cutList,character,list-method}
\title{initialize \code{cutList}-objects depending on argument \code{type}}
\usage{
init.cutList(type, input)

\S4method{init.cutList}{character,list}(type, input)
}
\arguments{
\item{type}{a character vector of length 1 defining what|how to initialize. Allowed types are:}
\itemize{
\item empty: create an empty \code{cutList}-object
\item singleCut: create a \code{cutList}-object with exactly one constraint
\item multipleCuts: create a \code{cutList}-object with more than one constraint}

\item{input}{a list depending on argument \code{type}.}

\itemize{
\item type==empty: input is not used (empty list)
\item type==singleCut: input is a list of length 3
\itemize{
\item first element: numeric vector specifying a values for the row of the constraint matrix that must be created
\item second element: character vector of length 1 specifying the direction
\item third element: numeric vector of length 1 specifying the right hand side of the constraint}
\item type==multipleCuts: input is a list of length 3
\itemize{
\item first element: object of class \code{matrix}
\item second element: character vector specifying the direction of the constraints
\item third element: numeric vector specifying the right hand side of the constraints}}
}
\value{
an object of class \code{cutList}
}
\description{
initialize \code{cutList}-objects depending on argument \code{type}
}
\note{
internal function
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}
\keyword{internal}
