% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drifts.R
\name{driftWn}
\alias{driftWn}
\title{Drift for the WN diffusion}
\usage{
driftWn(x, A, mu, Sigma, invSigmaA = NULL, maxK = 2, expTrc = 30)
}
\arguments{
\item{x}{matrix of size \code{c(n, p)} with the evaluation points for the drift.}

\item{A}{matrix of size \code{c(p, p)} giving the drift strength.}

\item{mu}{vector of length \code{p} with the unconditional mean of the diffusion.}

\item{Sigma}{diffusion matrix, of size \code{c(p, p)}.}

\item{invSigmaA}{the matrix \code{solve(Sigma) \%*\% A} (optional).}

\item{maxK}{maximum absolute value of the windings considered in the computation of the WN.}

\item{expTrc}{truncation for exponential: \code{exp(x)} with \code{x <= -expTrc} is set to zero. Defaults to \code{30}.}
}
\value{
A matrix of the same size as \code{x} containing the drift.
}
\description{
Drift for the Langevin diffusion associated to the (multivariate) Wrapped Normal (WN) in dimension \code{p}.
}
\details{
See Section 2.2.2 in García-Portugués et al. (2019) for details.

\code{\link{driftWn1D}} and \code{\link{driftWn2D}} are more efficient for the 1D and 2D cases.
}
\examples{
# 1D
x <- seq(-pi, pi, l = 200)
plot(x, x, type = "n", ylab = "drift")
for (i in 1:20) {
  lines(x, driftWn(x = cbind(x), A = 1 * i / 20, mu = 0, Sigma = 1),
        col = rainbow(20)[i])
}

# 2D
x <- seq(-pi, pi, l = 100)
plotSurface2D(x, x, f = function(x) sqrt(rowSums(
              driftWn(x = x, A = alphaToA(alpha = c(1, 1, 0.5),
                                          sigma = c(1.5, 1.5)), mu = c(0, 0),
              Sigma = diag(c(1.5^2, 1.5^2)))^2)), fVect = TRUE)
}
\references{
García-Portugués, E., Sørensen, M., Mardia, K. V. and Hamelryck, T. (2019) Langevin diffusions on the torus: estimation and applications. \emph{Statistics and Computing}, 29(2):1--22. \url{https://doi.org/10.1007/s11222-017-9790-2}
}
