% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample-trajectories.R
\name{rTrajWn1D}
\alias{rTrajWn1D}
\title{Simulation of trajectories for the WN diffusion in 1D}
\usage{
rTrajWn1D(x0, alpha, mu, sigma, N = 100, delta = 0.01, NFine = ceiling(N
  * delta/deltaFine), deltaFine = min(delta/100, 0.001))
}
\arguments{
\item{x0}{initial point.}

\item{alpha}{drift parameter.}

\item{mu}{mean parameter. Must be in \eqn{[\pi,\pi)}.}

\item{sigma}{diffusion coefficient.}

\item{N}{number of discretization steps in the resulting trajectory.}

\item{delta}{discretization step.}

\item{NFine}{number of discretization steps for the fine trajectory. Must be larger than \code{N}.}

\item{deltaFine}{discretization step for the fine trajectory. Must be smaller than \code{delta}.}
}
\value{
A vector of length \code{N + 1} containing \code{x0} in the first entry and the discretized trajectory.
}
\description{
Simulation of the Wrapped Normal (WN) diffusion in 1D by subsampling a fine trajectory obtained by the Euler discretization.
}
\details{
The fine trajectory is subsampled using the indexes \code{seq(1, NFine + 1, by = NFine / N)}.
}
\examples{
isRStudio <- identical(.Platform$GUI, "RStudio")
if (isRStudio) {
  manipulate::manipulate({
    x <- seq(0, N * delta, by = delta)
    plot(x, x, ylim = c(-pi, pi), type = "n", ylab = expression(X[t]), xlab = "t")
    linesCirc(x, rTrajWn1D(x0 = 0, alpha = alpha, mu = 0, sigma = sigma, N = N,
                             delta = 0.01))
    }, delta = slider(0.01, 5.01, step = 0.1),
    N = manipulate::slider(10, 500, step = 10, initial = 200),
    alpha = manipulate::slider(0.01, 5, step = 0.1, initial = 1),
    sigma = manipulate::slider(0.01, 5, step = 0.1, initial = 1))
}
}
