% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_sensitive_variable.R
\name{replace_firstname}
\alias{replace_firstname}
\title{Replace the firstnames with values from another database.}
\usage{
replace_firstname(
  dataset,
  country = "uk",
  age_dependency = TRUE,
  gender_dependency = TRUE,
  race_dependency = FALSE
)
}
\arguments{
\item{dataset}{A data frame of the dataset.}

\item{country}{A string variable with a default of 'uk'. It is either
'uk' or 'us'.}

\item{age_dependency}{A logical variable with a default of TRUE.}

\item{gender_dependency}{A logical variable with a default of TRUE.}

\item{race_dependency}{A logical variable with a default of FALSE.}
}
\value{
A data frame of the \code{dataset} with the firstname column being replaced
    by another firstname database.
}
\description{
\code{replace_firstname} replaces the firstname in \code{dataset} with firstname from
    another database (see \code{\link{firstname_uk}} and \code{\link{firstname_us}})
    in case they are too sensitive.
}
\examples{
df <- data.frame(sex=sample(c('male', 'female'), 30, replace = TRUE))
df <- add_variable(df, "nhsid")
df <- add_variable(df, "firstname", country = "uk", gender_dependency= TRUE, age_dependency = FALSE)
replace_firstname(df, country = 'us', age_dependency = FALSE)

}
