% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\encoding{UTF-8}
\name{plot_correlation}
\alias{plot_correlation}
\title{Plot the correlation matrix for the provided layercodes}
\usage{
plot_correlation(layers_correlation, prettynames = list(),
  palette = c("#2c7bb6", "#abd9e9", "#ffffbf", "#fdae61", "#d7191c"))
}
\arguments{
\item{layers_correlation}{matrix or dataframe. A square matrix with the
layers correlations you want to plot as returned by 
\code{\link{layers_correlation}} or 
\code{\link{pearson_correlation_matrix}}.}

\item{prettynames}{list. Optional list with as names the layercodes and as 
values the name of the layer to be used in the plot.}

\item{palette}{character vector. optional vector with 5 entries for the range
of colors to be used for the correlation matrix plot.}
}
\value{
A ggplot object that can be printed or saved.
}
\description{
#' \code{plot_correlation} creates a plot of the correlation between 
different layers
}
\details{
This function requires ggplot2 and plots the correlations for the 
  layers in the same order as the layercodes are provided to this function.
}
\examples{
correlation <- layers_correlation(c("BO_calcite", "BO_damin", "MS_bathy_5m"))
p <- plot_correlation(correlation)
print(p)

}
\seealso{
\code{ \link{layers_correlation} \link{pearson_correlation_matrix} 
  \link{list_layers} \link{layer_stats} \link{correlation_groups}}
}

