/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.sdols.clustering;

import java.io.Serializable;
import org.apache.commons.math3.util.FastMath;
import org.ddahl.commonsmath.package;
import org.ddahl.commonsmath.package$;
import org.ddahl.sdols.clustering.Cluster;
import org.ddahl.sdols.clustering.Cluster$;
import org.ddahl.sdols.clustering.Clustering;
import org.ddahl.sdols.clustering.Clustering$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Random;

public final class ClusteringSummary$ {
    public static ClusteringSummary$ MODULE$;

    static {
        new ClusteringSummary$();
    }

    public <A> double[][] expectedPairwiseAllocationMatrix(Seq<Clustering<A>> clusterings) {
        int nItems = ((Clustering)clusterings.apply(0)).nItems();
        int[][] x = (int[][])Array$.MODULE$.ofDim(nItems, nItems, ClassTag$.MODULE$.Int());
        clusterings.foreach((Function1 & Serializable & scala.Serializable)clustering -> {
            clustering.foreach((Function1 & Serializable & scala.Serializable)cluster -> {
                ClusteringSummary$.$anonfun$expectedPairwiseAllocationMatrix$2(x$25, cluster);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        double cl = clusterings.length();
        return (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).map((Function1 & Serializable & scala.Serializable)x$1 -> (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x$1)).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$2 -> (double)x$2 / cl, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    public double[][] expectedPairwiseAllocationMatrix(int[][] clusterings) {
        int n = clusterings[0].length;
        int[][] x = (int[][])Array$.MODULE$.ofDim(n, n, ClassTag$.MODULE$.Int());
        for (int k = 0; k < clusterings.length; ++k) {
            int[] p = clusterings[k];
            for (int i = 0; i < n; ++i) {
                int[] xi = x[i];
                int pi = p[i];
                for (int j = 0; j < n; ++j) {
                    if (pi != p[j]) continue;
                    int n2 = j;
                    xi[n2] = xi[n2] + 1;
                }
            }
        }
        double cl = clusterings.length;
        return (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x)).map((Function1 & Serializable & scala.Serializable)x$3 -> (double[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x$3)).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$4 -> (double)x$4 / cl, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    public <A> Tuple5<int[], double[], double[][], int[], int[]> confidenceComputations(int[] clustering, double[][] pam) {
        int nItems = pam.length;
        Predef$.MODULE$.assert(clustering.length == nItems);
        List<Set<Object>> clustering2 = this.makeClustering(clustering);
        HashMap matrix = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        clustering2.foreach((Function1 & Serializable & scala.Serializable)s1 -> {
            clustering2.foreach((Function1 & Serializable & scala.Serializable)s2 -> {
                matrix$1.update((Object)new Tuple2((Object)s1, (Object)s2), (Object)BoxesRunTime.boxToDouble((double)ClusteringSummary$.overlap$1(s1, s2, pam$1)));
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        List clustersWithSumOverlap = (List)clustering2.map((Function1 & Serializable & scala.Serializable)s1 -> new Tuple2(s1, ((TraversableOnce)clustering2.map((Function1 & Serializable & scala.Serializable)s2 -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.$anonfun$confidenceComputations$6(matrix, s1, s2)), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), List$.MODULE$.canBuildFrom());
        List sortedClusters = (List)((List)clustersWithSumOverlap.sortWith((Function2 & Serializable & scala.Serializable)(t1, t2) -> BoxesRunTime.boxToBoolean((boolean)ClusteringSummary$.$anonfun$confidenceComputations$7(t1, t2)))).map((Function1 & Serializable & scala.Serializable)x$5 -> (Set)x$5._1(), List$.MODULE$.canBuildFrom());
        Map map = ((TraversableOnce)sortedClusters.zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        double[][] matrixOutSmall = (double[][])Array$.MODULE$.ofDim(clustering2.size(), clustering2.size(), ClassTag$.MODULE$.Double());
        clustering2.foreach((Function1 & Serializable & scala.Serializable)c1 -> {
            clustering2.foreach((Function1 & Serializable & scala.Serializable)c2 -> {
                matrixOutSmall$1[BoxesRunTime.unboxToInt((Object)map$1.apply((Object)c1))][BoxesRunTime.unboxToInt((Object)map$1.apply((Object)c2))] = BoxesRunTime.unboxToDouble((Object)matrix$1.apply((Object)new Tuple2((Object)c1, (Object)c2)));
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        double[] confidence = new double[nItems];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nItems).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            double[] ppmi = pam[i];
            Set cluster = (Set)clustering2.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.contains((Object)BoxesRunTime.boxToInteger((int)i)))).get();
            confidence$1[i] = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)cluster.map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> ppmi[j], Set$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)cluster.size();
        });
        int UNINITIALIZED = -1;
        int[] exemplar = (int[])Array$.MODULE$.fill(map.size(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> UNINITIALIZED, ClassTag$.MODULE$.Int());
        int[] order = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(0, nItems))).sortWith((Function2)(JFunction2.mcZII.sp & Serializable & scala.Serializable)(i, j) -> {
            boolean bl;
            int jo;
            int io = BoxesRunTime.unboxToInt((Object)map.apply(clustering2.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.contains((Object)BoxesRunTime.boxToInteger((int)i)))).get()));
            if (io < (jo = BoxesRunTime.unboxToInt((Object)map.apply(clustering2.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.contains((Object)BoxesRunTime.boxToInteger((int)j)))).get())))) {
                bl = true;
            } else if (io > jo) {
                bl = false;
            } else {
                boolean iBigger;
                boolean bl2 = iBigger = confidence[i] > confidence[j];
                if (iBigger) {
                    if (exemplar[io] == UNINITIALIZED || confidence[exemplar[io]] < confidence[i]) {
                        exemplar$1[io] = i;
                    }
                } else if (exemplar[jo] == UNINITIALIZED || confidence[exemplar[jo]] < confidence[j]) {
                    exemplar$1[jo] = j;
                }
                bl = iBigger;
            }
            return bl;
        });
        int[] labels = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(0, nItems))).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToInt((Object)map.apply(clustering2.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.contains((Object)BoxesRunTime.boxToInteger((int)i)))).get())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        return new Tuple5((Object)labels, (Object)confidence, (Object)matrixOutSmall, (Object)order, (Object)exemplar);
    }

    private List<Set<Object>> makeClustering(Iterable<Tuple2<Object, Object>> labelsWithIndex, List<Set<Object>> list) {
        List longerList;
        while (true) {
            int label;
            Tuple2 tuple2;
            if ((tuple2 = labelsWithIndex.partition(arg_0 -> ClusteringSummary$.$anonfun$makeClustering$1$adapted(label = ((Tuple2)labelsWithIndex.head())._1$mcI$sp(), arg_0))) == null) {
                throw new MatchError((Object)tuple2);
            }
            Iterable left = (Iterable)tuple2._1();
            Iterable right = (Iterable)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)left, (Object)right);
            Tuple2 tuple23 = tuple22;
            Iterable left2 = (Iterable)tuple23._1();
            Iterable right2 = (Iterable)tuple23._2();
            Set set = ((TraversableOnce)left2.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12._2$mcI$sp()), Iterable$.MODULE$.canBuildFrom())).toSet();
            longerList = (List)list.$plus$colon((Object)set, List$.MODULE$.canBuildFrom());
            if (right2.isEmpty()) break;
            list = longerList;
            labelsWithIndex = right2;
        }
        return longerList;
    }

    private List<Set<Object>> makeClustering(int[] clustering) {
        if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(clustering)).isEmpty()) {
            throw new IllegalArgumentException("Labels may not by empty.");
        }
        return this.makeClustering((Iterable<Tuple2<Object, Object>>)((Iterable)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(clustering)).zipWithIndex(Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), (List<Set<Object>>)Nil$.MODULE$);
    }

    public <A> double lowerBoundVariationOfInformation(Clustering<A> clustering, double[][] pam) {
        int nItems = clustering.nItems();
        double sum1 = 0.0;
        for (int i = 0; i < nItems; ++i) {
            int sum2 = 0;
            double sum3 = 0.0;
            double sum4 = 0.0;
            for (int j = 0; j < nItems; ++j) {
                sum2 += clustering.paired(i, j) ? 1 : 0;
                sum3 += pam[i][j];
                sum4 += clustering.paired(i, j) ? pam[i][j] : 0.0;
            }
            sum1 += FastMath.log((double)2.0, (double)sum2) + FastMath.log((double)2.0, (double)sum3) - (double)2 * FastMath.log((double)2.0, (double)sum4);
        }
        return sum1 / (double)nItems;
    }

    /*
     * WARNING - void declaration
     */
    private <A> double lowerBoundVariationOfInformationEngine(Clustering<A> clustering, double[][] pam) {
        void var3_3;
        double sum = 0.0;
        Cluster[] clusters = (Cluster[])clustering.toArray(ClassTag$.MODULE$.apply(Cluster.class));
        for (int k = 0; k < clusters.length; ++k) {
            int[] cluster = (int[])clusters[k].toArray(ClassTag$.MODULE$.Int());
            sum += (double)cluster.length * FastMath.log((double)2.0, (double)cluster.length);
            double sum2 = 0.0;
            for (int ii = 0; ii < cluster.length; ++ii) {
                double sum3 = 0.0;
                double[] pamii = pam[cluster[ii]];
                for (int jj = 0; jj < cluster.length; ++jj) {
                    sum3 += pamii[cluster[jj]];
                }
                sum2 += FastMath.log((double)2.0, (double)sum3);
            }
            sum -= (double)2 * sum2;
        }
        return (double)var3_3;
    }

    public <A> double sumOfAbsolutesSlow(Clustering<A> clustering, double[][] pam) {
        return package$.MODULE$.RichRealMatrix(package$.MODULE$.RichArray2DRowRealMatrix(package$.MODULE$.RichArray2DRowRealMatrix(package.MatrixFactory$.MODULE$.apply(clustering.pairwiseAllocationMatrix())).$minus(pam)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$14 -> RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x$14)))).sum();
    }

    public <A> double sumOfSquaresSlow(Clustering<A> clustering, double[][] pam) {
        return package$.MODULE$.RichRealMatrix(package$.MODULE$.RichArray2DRowRealMatrix(package$.MODULE$.RichArray2DRowRealMatrix(package.MatrixFactory$.MODULE$.apply(clustering.pairwiseAllocationMatrix())).$minus(pam)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x * x)).sum();
    }

    private <A> double binderOffset(double[][] pam, Function1<Object, Object> f) {
        double offset = 0.0;
        for (int i = 1; i < pam.length; ++i) {
            double[] pi = pam[i];
            for (int j = 0; j < i; ++j) {
                offset += f.apply$mcDD$sp(pi[j]);
            }
        }
        return (double)2 * offset;
    }

    public <A> double sumOfAbsolutes(Clustering<A> clustering, double[][] pam) {
        double[][] pamTransform = (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pam)).map((Function1 & Serializable & scala.Serializable)x$15 -> (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$15)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> (double)2 - (double)4 * x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        return this.binderOffset(pam, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x))) + this.binderEngine(clustering, pamTransform);
    }

    public <A> double sumOfSquares(Clustering<A> clustering, double[][] pam) {
        double[][] pamTransform = (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pam)).map((Function1 & Serializable & scala.Serializable)x$16 -> (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$16)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> (double)2 - (double)4 * x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        return this.binderOffset(pam, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x * x) + this.binderEngine(clustering, pamTransform);
    }

    private <A> double binderEngine(Clustering<A> clustering, double[][] pamTransform) {
        DoubleRef sum = DoubleRef.create((double)0.0);
        clustering.foreach((Function1 & Serializable & scala.Serializable)cluster -> {
            ClusteringSummary$.$anonfun$binderEngine$1(pamTransform, sum, cluster);
            return BoxedUnit.UNIT;
        });
        return sum.elem;
    }

    public Clustering<Null$> minAmongDraws(int[][] candidates, int maxSize, boolean multicore, String loss, Option<double[][]> pamOption) {
        return this.minAmongDraws((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])candidates)).map((Function1 & Serializable & scala.Serializable)labels -> Clustering$.MODULE$.apply((int[])labels), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Clustering.class)))), maxSize, multicore, loss, pamOption);
    }

    public <A> Clustering<A> minAmongDraws(Seq<Clustering<A>> candidates, int maxSize, boolean multicore, String loss, Option<double[][]> pamOption) {
        if (candidates.isEmpty()) {
            throw new IllegalArgumentException("'candidates' cannot be empty.");
        }
        double[][] pam = (double[][])pamOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.expectedPairwiseAllocationMatrix((Seq)candidates));
        Tuple2<Function2<Clustering<A>, double[][], Object>, double[][]> tuple2 = this.getLoss(loss, pam);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Function2 lossEngine = (Function2)tuple2._1();
        double[][] pamTransform = (double[][])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)lossEngine, (Object)pamTransform);
        Tuple2 tuple23 = tuple22;
        Function2 lossEngine2 = (Function2)tuple23._1();
        double[][] pamTransform2 = (double[][])tuple23._2();
        GenSeq iter = multicore ? (GenSeq)candidates.par() : candidates;
        return (Clustering)iter.minBy((Function1 & Serializable & scala.Serializable)clustering -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.$anonfun$minAmongDraws$3(maxSize, lossEngine2, pamTransform2, clustering)), (Ordering)Ordering.Double$.MODULE$);
    }

    public Option<double[][]> minAmongDraws$default$5() {
        return None$.MODULE$;
    }

    private Clustering<Null$> sequentiallyAllocatedLatentStructureOptimization(Clustering<Null$> initial, int maxSize, List<Object> permutation, double[][] pamTransform, Function2<Clustering<Null$>, double[][], Object> lossEngine) {
        ObjectRef clustering = ObjectRef.create(initial);
        permutation.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            List list;
            List candidates = ((TraversableOnce)((Clustering)clustering$1.elem).map((Function1 & Serializable & scala.Serializable)cluster -> ((Clustering)clustering$1.elem).add(i, cluster), Iterable$.MODULE$.canBuildFrom())).toList();
            if (maxSize <= 0 || ((Clustering)clustering$1.elem).size() < maxSize) {
                Clustering<Object> clustering = ((Clustering)clustering$1.elem).add(Cluster$.MODULE$.apply(null, i));
                list = candidates.$colon$colon(clustering);
            } else {
                list = candidates;
            }
            List candidates2 = list;
            clustering$1.elem = (Clustering)candidates2.minBy((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimization$3(pamTransform, lossEngine, x$19)), (Ordering)Ordering.Double$.MODULE$);
        });
        return (Clustering)clustering.elem;
    }

    private Tuple2<Clustering<Null$>, Object> sequentiallyAllocatedLatentStructureOptimizationFaster(Clustering<Null$> initial, int maxSize, int maxScans, List<Object> permutation, double[][] pamTransform) {
        Tuple2 emptyTuple = new Tuple2(Cluster$.MODULE$.empty(null), (Object)BoxesRunTime.boxToDouble((double)0.0));
        ObjectRef clustering = ObjectRef.create(initial);
        BooleanRef firstPass = BooleanRef.create((boolean)true);
        boolean notDone = true;
        int scanCounter = -1;
        while (firstPass.elem || notDone) {
            ++scanCounter;
            Clustering previousClustering = (Clustering)clustering.elem;
            permutation.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                List list;
                if (!firstPass$1.elem) {
                    clustering$2.elem = ((Clustering)clustering$2.elem).remove(i);
                }
                double[] pamTransformi = pamTransform[i];
                List candidates = ((TraversableOnce)((Clustering)clustering$2.elem).map((Function1 & Serializable & scala.Serializable)cluster -> new Tuple2(cluster, (Object)cluster.foldLeft(BoxesRunTime.boxToDouble((double)0.0), (JFunction2.mcDDI.sp & Serializable & scala.Serializable)(sum, j) -> sum + pamTransformi[j])), Iterable$.MODULE$.canBuildFrom())).toList();
                if (maxSize <= 0 || ((Clustering)clustering$2.elem).size() < maxSize) {
                    Tuple2 tuple2 = emptyTuple;
                    list = candidates.$colon$colon((Object)tuple2);
                } else {
                    list = candidates;
                }
                List candidates2 = list;
                clustering$2.elem = ((Clustering)clustering$2.elem).add(i, (Cluster)((Tuple2)candidates2.minBy((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToDouble((double)x$21._2$mcD$sp()), (Ordering)Ordering.Double$.MODULE$))._1());
            });
            if (firstPass.elem) {
                firstPass.elem = false;
            }
            Clustering clustering2 = (Clustering)clustering.elem;
            Clustering clustering3 = previousClustering;
            notDone = (clustering2 == null ? clustering3 != null : !((Object)clustering2).equals(clustering3)) && scanCounter < maxScans;
        }
        return new Tuple2((Object)((Clustering)clustering.elem), (Object)BoxesRunTime.boxToInteger((int)scanCounter));
    }

    private <A> Tuple2<Function2<Clustering<A>, double[][], Object>, double[][]> getLoss(String loss, double[][] pam2) {
        Tuple2 tuple2;
        String string = loss;
        boolean bl = "binder".equals(string) ? true : ("squaredError".equals(string) ? true : "absoluteError".equals(string));
        if (bl) {
            tuple2 = new Tuple2((Function2 & Serializable & scala.Serializable)(clustering, pamTransform) -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.MODULE$.binderEngine(clustering, pamTransform)), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pam2)).map((Function1 & Serializable & scala.Serializable)x$22 -> (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$22)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> 0.5 - x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
        } else if ("lowerBoundVariationOfInformation".equals(string)) {
            tuple2 = new Tuple2((Function2 & Serializable & scala.Serializable)(clustering, pam) -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.MODULE$.lowerBoundVariationOfInformationEngine(clustering, pam)), (Object)pam2);
        } else {
            throw new MatchError((Object)string);
        }
        return tuple2;
    }

    public Tuple3<Clustering<Null$>, Object, Object> sequentiallyAllocatedLatentStructureOptimization(int nCandidates, double budgetInSeconds, double[][] pam, int maxSize, int maxScans, boolean multicore, String loss) {
        Tuple2 tuple2 = this.getLoss(loss, pam);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Function2 lossEngine = (Function2)tuple2._1();
        double[][] pamTransform = (double[][])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)lossEngine, (Object)pamTransform);
        Tuple2 tuple23 = tuple22;
        Function2 lossEngine2 = (Function2)tuple23._1();
        double[][] pamTransform2 = (double[][])tuple23._2();
        String string = loss;
        String string2 = "lowerBoundVariationOfInformation";
        boolean useFasterAlgorithm = string == null ? string2 != null : !string.equals(string2);
        Random rng = new Random();
        int nItems = pam.length;
        List ints = (List)List$.MODULE$.tabulate(nItems, (Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x))));
        Clustering empty = Clustering$.MODULE$.empty();
        int nCores = multicore ? Runtime.getRuntime().availableProcessors() : 1;
        int nCandidatesPerThread = (nCandidates - 1) / nCores + 1;
        double budgetInMillis = budgetInSeconds <= 0.0 ? 9.223372036854776E18 : budgetInSeconds * (double)1000L;
        long start = System.currentTimeMillis();
        List futures = (List)List$.MODULE$.fill(nCores, (Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            int counter;
            double minScore = Double.POSITIVE_INFINITY;
            Tuple2 best = new Tuple2(null, (Object)BoxesRunTime.boxToInteger((int)-1));
            for (counter = 0; counter < nCandidatesPerThread && (double)(System.currentTimeMillis() - start) <= budgetInMillis; ++counter) {
                List permutation = (List)rng.shuffle((TraversableOnce)ints, List$.MODULE$.canBuildFrom());
                Tuple2 tuple2 = useFasterAlgorithm ? MODULE$.sequentiallyAllocatedLatentStructureOptimizationFaster(empty, maxSize, maxScans, (List<Object>)permutation, pamTransform2) : new Tuple2(MODULE$.sequentiallyAllocatedLatentStructureOptimization(empty, maxSize, (List<Object>)permutation, pamTransform2, (Function2<Clustering<Null$>, double[][], Object>)lossEngine2), (Object)BoxesRunTime.boxToInteger((int)-1));
                Tuple2 candidate = tuple2;
                double score = BoxesRunTime.unboxToDouble((Object)lossEngine2.apply(candidate._1(), (Object)pamTransform2));
                if (!(score < minScore)) continue;
                minScore = score;
                best = candidate;
            }
            return new Tuple4(best._1(), (Object)BoxesRunTime.boxToInteger((int)best._2$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)minScore), (Object)BoxesRunTime.boxToInteger((int)counter));
        }, ExecutionContext.Implicits$.MODULE$.global()));
        List seq = (List)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, List$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Duration$.MODULE$.Inf());
        int nCandidatesInPractice = BoxesRunTime.unboxToInt((Object)seq.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(sum, tuple) -> BoxesRunTime.boxToInteger((int)ClusteringSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimization$7(BoxesRunTime.unboxToInt((Object)sum), tuple))));
        Tuple4 best = (Tuple4)seq.minBy((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToDouble((double)ClusteringSummary$.$anonfun$sequentiallyAllocatedLatentStructureOptimization$8(x$24)), (Ordering)Ordering.Double$.MODULE$);
        return new Tuple3(best._1(), best._2(), (Object)BoxesRunTime.boxToInteger((int)nCandidatesInPractice));
    }

    public static final /* synthetic */ void $anonfun$expectedPairwiseAllocationMatrix$2(int[][] x$25, Cluster cluster) {
        int[] y = (int[])cluster.toArray(ClassTag$.MODULE$.Int());
        for (int i = 0; i < y.length; ++i) {
            int ii = y[i];
            for (int j = i + 1; j < y.length; ++j) {
                int jj = y[j];
                int[] nArray = x$25[ii];
                nArray[jj] = nArray[jj] + 1;
                int[] nArray2 = x$25[jj];
                nArray2[ii] = nArray2[ii] + 1;
            }
            int[] nArray = x$25[ii];
            nArray[ii] = nArray[ii] + 1;
        }
    }

    private static final double overlap$1(Set cluster1, Set cluster2, double[][] pam$1) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)cluster1.map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
            double[] pami = pam$1[i];
            return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)cluster2.map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> pami[j], Set$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        }, Set$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)(cluster1.size() * cluster2.size());
    }

    public static final /* synthetic */ double $anonfun$confidenceComputations$6(HashMap matrix$1, Set s1$2, Set s2) {
        return BoxesRunTime.unboxToDouble((Object)matrix$1.apply((Object)new Tuple2((Object)s1$2, (Object)s2)));
    }

    public static final /* synthetic */ boolean $anonfun$confidenceComputations$7(Tuple2 t1, Tuple2 t2) {
        return t1._2$mcD$sp() < t2._2$mcD$sp();
    }

    public static final /* synthetic */ boolean $anonfun$makeClustering$1(int label$1, Tuple2 x$10) {
        return x$10._1$mcI$sp() == label$1;
    }

    public static final /* synthetic */ void $anonfun$binderEngine$1(double[][] pamTransform$1, DoubleRef sum$1, Cluster cluster) {
        int[] y = (int[])cluster.toArray(ClassTag$.MODULE$.Int());
        for (int i = 0; i < y.length; ++i) {
            double[] xx = pamTransform$1[y[i]];
            for (int j = i + 1; j < y.length; ++j) {
                sum$1.elem += xx[y[j]];
            }
        }
    }

    public static final /* synthetic */ double $anonfun$minAmongDraws$3(int maxSize$1, Function2 lossEngine$1, double[][] pamTransform$2, Clustering clustering) {
        return maxSize$1 > 0 && clustering.size() > maxSize$1 ? Double.POSITIVE_INFINITY : BoxesRunTime.unboxToDouble((Object)lossEngine$1.apply((Object)clustering, (Object)pamTransform$2));
    }

    public static final /* synthetic */ double $anonfun$sequentiallyAllocatedLatentStructureOptimization$3(double[][] pamTransform$3, Function2 lossEngine$2, Clustering x$19) {
        return BoxesRunTime.unboxToDouble((Object)lossEngine$2.apply((Object)x$19, (Object)pamTransform$3));
    }

    public static final /* synthetic */ int $anonfun$sequentiallyAllocatedLatentStructureOptimization$7(int sum, Tuple4 tuple) {
        return sum + BoxesRunTime.unboxToInt((Object)tuple._4());
    }

    public static final /* synthetic */ double $anonfun$sequentiallyAllocatedLatentStructureOptimization$8(Tuple4 x$24) {
        return BoxesRunTime.unboxToDouble((Object)x$24._3());
    }

    private ClusteringSummary$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Object $anonfun$makeClustering$1$adapted(int label$1, Tuple2 x$10) {
        return BoxesRunTime.boxToBoolean((boolean)ClusteringSummary$.$anonfun$makeClustering$1(label$1, x$10));
    }
}

