% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latentStructureFit.R
\name{latentStructureFit}
\alias{latentStructureFit}
\title{Compute Fit Summaries for a Latent Structure Estimate}
\usage{
latentStructureFit(estimate, expectedPairwiseAllocationMatrix)
}
\arguments{
\item{estimate}{A clustering or feature allocation.  If \code{estimate} is a length \code{n}
vector, it is taken to be a clustering where items \code{i} and
\code{j} are in the same cluster if and only if \code{estimate[i] == estimate[j]}.  If \code{estimate}
is a binary matrix of \code{n} rows and an arbitrary number of columns, it is taken to be a feature allocation
where items \code{i} and \code{j} share \code{m} features if, for \code{k}
= 1, 2, ..., the expression \code{estimate[i,k] == estimate[j,k] == 1} is true exactly
\code{m} times.}

\item{expectedPairwiseAllocationMatrix}{A \code{n}-by-\code{n} symmetric matrix
whose \code{(i,j)} elements gives the estimated expected number of times that items
\code{i} and \code{j} are in the same subset (i.e., cluster or feature).}
}
\description{
This function computes various summaries of the fit of a clustering or feature allocation based on the expected
pairwise allocation matrix.
}
\examples{
\donttest{
probabilities <- expectedPairwiseAllocationMatrix(iris.clusterings)
estimate <- salso(probabilities)
latentStructureFit(estimate, probabilities)

expectedCounts <- expectedPairwiseAllocationMatrix(USArrests.featureAllocations)
estimate <- salso(expectedCounts,"featureAllocation")
latentStructureFit(estimate, expectedCounts)

\dontshow{
rscala::scalaDisconnect(sdols:::s)
}
}

}
\seealso{
\code{\link{expectedPairwiseAllocationMatrix}}, \code{\link{salso}}
}
\author{
David B. Dahl \email{dahl@stat.byu.edu}
}
