% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collect.R
\name{collect}
\alias{collect}
\alias{global_objects}
\alias{nms_objects}
\alias{ls_objects}
\title{Collect \R{} object}
\usage{
global_objects()

nms_objects(pkgs = NULL, ...)

ls_objects(class = NULL, environment = ".GlobalEnv", eval = FALSE,
  nms = FALSE, ...)
}
\arguments{
\item{pkgs}{The name of a package such as \code{package:<PACKAGE_NAME>}}

\item{...}{Further arguments}

\item{class}{Class of \R{} object (\code{character})}

\item{environment}{which environment (work space) to search the available objects}

\item{eval}{which include evaluate value}

\item{nms}{attached packages names}
}
\description{
Collect \R{} object
}
\details{
\itemize{
\item ls_objects
}
}
\examples{
\dontrun{
# Return objects in .GlobaEnv
my_iris <- iris
ls_objects()
# Filter by object class
ls_objects("data.frame")
# Storage a evaluate value
ls_objects("data.frame", eval = TRUE)

# Filter object class and environment
ls_objects("data.frame",
           nms = TRUE,
           pkgs = "package:datasets")

library(dplyr)
ls_objects(c("function", "tbl"),
           nms = TRUE,
           pkgs = "package:dplyr")

e <- rlang::env(my_data1 = iris, my_data2 = mtcars)
ls_objects(environment = "e", nms = FALSE)
}
}
