\name{scenarioSummary}
\alias{scenarioSummary}

\title{Summary of Scenarios}

\description{Compute various deterministic summaries for scenarios generated by \code{make.scenarios}}

\usage{

scenarioSummary(scenarios, trapset, maskset, xsigma = 4, nx = 64, CF = 1.0, 
    costing = FALSE, ..., ncores = 1)

}

\arguments{
  \item{scenarios}{dataframe of simulation scenarios}
  \item{trapset}{secr traps object or a list of traps objects}
  \item{maskset}{secr mask object or a list of mask objects (optional)}
  \item{xsigma}{numeric buffer width as multiple of sigma (alternative
  to maskset)}
  \item{nx}{integer number of cells in mask in x direction  (alternative
  to maskset)}
  \item{CF}{numeric correction factor for rule-of-thumb RSE (see \code{\link{minnrRSE}})}
  \item{costing}{logical; if TRUE then costings will be appended}
  \item{\dots}{arguments passed to \code{\link{costing}}}
  \item{ncores}{integer number of cores for parallel processing}
}

\details{

Not all scenarios from \code{make.scenarios()} are suitable. Grouped (multi-line) scenarios are excluded. Hazard detection functions are preferred (`HHN', `HHR', `HEX', `HAN', `HCG'). `HN', `HR' and `EX' are converted approximately to `HHN', `HHR' and `HEX' respectively, with a warning; other functions are rejected.

\code{CF} may be a vector of values that is recycled across the components of \code{trapset}.

The approximate RSE(D-hat) is rotRSE = CF/ sqrt(min(E(n), E(r))). This assumes n is Poisson-distributed. For binomial n an ad hoc adjustment is rotRSEB = sqrt(rotRSE^2 - 1 / (D x A)) where A is the mask area.

The \dots argument is for inputs to \code{\link{costing}}, including \code{unitcost} (required) and routelength (optional). 

}

\value{

A dataframe including the first 8 columns from scenarios and the computed columns --

\item{En}{expected number of individuals}
\item{Er}{expected number of recaptures}
\item{Em}{expected number of movement recaptures}
\item{esa}{effective sampling area (ha)}
\item{CF}{rule-of-thumb correction factor}
\item{rotRSE}{rule-of-thumb relative standard error of density estimate}
\item{rotRSEB}{rotRSE with adjustment for fixed N in region defined by mask (i.e. Binomial \eqn{n} rather than Poisson \eqn{n})}
\item{arrayN}{number of detectors in each array}
\item{arrayspace}{array spacing in sigma units}
\item{arrayspan}{largest dimension of array in sigma units}
\item{travel}{travel cost}
\item{arrays}{cost of each repeated array}
\item{detectors}{fixed cost per detector}
\item{visits}{cost per detector per visit}
\item{detections}{cost per detection }
\item{totalcost}{summed costs}
  
Costings (the last 6 columns) are omitted if \code{costing = FALSE}.

}

\seealso{

\code{\link{make.scenarios}}, 
\code{\link{Enrm}}, 
\code{\link{costing}}, 
\code{\link{minnrRSE}}

}

\examples{

scen <- make.scenarios(D = c(5,10), sigma = 25, lambda0 = 0.2, detectfn = 'HHN')
grid <- make.grid(6,6, detector = 'multi')
scenarioSummary(scen, list(grid), costing = TRUE, unitcost = list(perkm = 10))

}
