% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorize.R
\name{factorize}
\alias{factorize}
\alias{factorize_secuTrial}
\alias{factorize_secuTrial.secuTrialdata}
\title{Add factors to \code{secuTrialdata} objects}
\usage{
factorize_secuTrial(object, ...)

\method{factorize_secuTrial}{secuTrialdata}(object, ...)
}
\arguments{
\item{object}{\code{secuTrialdata} object with additional factor variables in study forms containing categorical data}

\item{...}{further parameters}
}
\value{
factorized \code{secuTrialdata} object
}
\description{
secuTrial can return a codebook of codes and labels for categorical variables, including lookup
             type variables, if this option is selected in the export tool ('reference values as separate table').
             This allows factors to be easily created. Factorize methods exist for \code{secuTrialdata} objects,
             \code{data.frames}, \code{integer}s and \code{logical}s, but the intent is that only the former be
             used by users. The other methods could be used with customized codebooks.
}
\details{
factorize_secuTrial will return an error if the appropriate codebook is not available.
}
\examples{
# load secuTrial export with separate reference table
sT_export <- read_secuTrial_raw(system.file("extdata", "sT_exports", "lnames",
                                            "s_export_CSV-xls_CTU05_long_ref_miss_en_utf8.zip",
                                            package = "secuTrialR"))
# factorize the secuTrialdata object
sT_export_factorized <- factorize_secuTrial(sT_export)
}
