% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/return_random_participants.R
\name{return_random_participants}
\alias{return_random_participants}
\title{Returns the random participants from a secuTrial export}
\usage{
return_random_participants(
  x,
  centres = "all",
  percent = 0.1,
  date = "1900-01-01",
  seed = 1
)
}
\arguments{
\item{x}{a \code{secuTrialdata} object}

\item{centres}{A character vector of centres for which participants should be returned. If left
unspecified it will return participants for every study centre.}

\item{percent}{A number greater than 0 and smaller than 1 specifying the approximate percentage
of participants to be returned per centre.}

\item{date}{If only participants after a specific date should be considered this can be entered here.
Format should be "YYYY-MM-DD" (e.g. "2011-03-26" for March 26th 2011).
This date is checked against mnpvisstartdate in the casenodes table.}

\item{seed}{Allows to configure a seed for id sampling. Every centre will use a small variation of this seed.}
}
\value{
list of two elements. First, a data.frame that contains the
         random participants from each specified centre. This is performed based on a specified seed to retain
         reproducibilty. Second, the configuration of the randomization (i.e. result of \code{RNGkind()}).
         If the percentage does not yield an integer for a centre the number is tranformed into an integer
         under application of the \code{ceiling()} function (i.e. it is rounded up).
}
\description{
There are situations (e.g. randomized monitoring) in which you may want to
             return a list of random participants from a secuTrial export.
}
\examples{
# export location
expot_loc <- system.file("extdata", "sT_exports", "lnames",
                         "s_export_CSV-xls_CTU05_long_ref_miss_en_utf8.zip",
                         package = "secuTrialR")
# read export
sT_export <- read_secuTrial(expot_loc)

# return random participants
return_random_participants(sT_export, percent = 0.25, seed = 1337, date = "2019-03-18",
                           centres = c("Inselspital Bern (RPACK)", "Charité Berlin (RPACK)"))

}
