% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_secuTrial_raw.R
\name{secuTrialdata}
\alias{secuTrialdata}
\alias{read_secuTrial_raw}
\alias{print.secuTrialdata}
\title{This function loads a secuTrial export}
\usage{
read_secuTrial_raw(data_dir)

\method{print}{secuTrialdata}(x, ...)
}
\arguments{
\item{data_dir}{string The data_dir specifies the path to the secuTrial data export.}

\item{x}{secuTrialdata object as returned by \code{read_secuTrial_raw}}

\item{...}{further parameters}
}
\value{
\code{secuTrialdata} object containing a list of
        export options and data.frames with all the data loaded from
        the secuTrial export.
        The list will contain at least the metadata data.frames and
        export_options list.

data.frame with a row for each table in the export. For each table it
        contains the name, number of rows and columns, an indicator for
        whether the table is a metadata table and the files original name.
}
\description{
This function will always load the full set of meta and data tables.
The export options are also loaded and written into export_options.
}
\examples{
# prepare path to example export
export_location <- system.file("extdata", "sT_exports", "BMD",
                               "s_export_CSV-xls_BMD_short_en_utf8.zip",
                               package = "secuTrialR")
# read all export data
sT_export <- read_secuTrial_raw(data_dir = export_location)

# Print method
print(sT_export)
# or
sT_export
}
