% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/how_to_plot.R
\name{how_to_plot}
\alias{how_to_plot}
\title{How to plot your object}
\usage{
how_to_plot(x, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Access the source code used for plotting.
}
\details{
The plotting-capability of the \pkg{see} package mainly evolve around
two functions: \code{\link[=data_plot]{data_plot()}}, which prepares the data from various
objects to bring it into shape for plotting, and \code{\link[=data_plot]{plot()}},
which takes the data from \code{data_plot()} and creates the ggplot-object.
Although ggplot-objects are easily modifiable, it is sometimes necessary to
build up a plot from scratch, using the data that should be plotted. This
is where \code{how_to_plot()} can help. It simply extracts and polishes the
code from the various \code{plot()} methods and prints it to the console.
This code can be used as "basis" for building own ggplots.
}
\examples{
\dontrun{
library(bayestestR)
results <- hdi(rnorm(1000))

how_to_plot(results)
}
}
